#include "defalloc.h"
#include "algo.h"
#include "tempbuf.cpp"  // Can also just compile and link with this file
#include "heap.h"
#include "function.h"
#include "vector.h"

#include "random.cpp"   // Can also just compile and link with this file

//Rand is used to fill the array with sequential numbers
class Rand{
   int I;

public:
   Rand(unsigned long X):I(X){}

   int operator()(){return I++;}
};


typedef vector<int> IVec;

void main(int argc, char *argv[]){
   vector<int> Set1,Set2,Output;

   ostream_iterator<int> out_stream(cout, " ");
   less<int> less_than;

   Set1.insert(Set1.end(),10);
   Set1.insert(Set1.end(),11);
   Set1.insert(Set1.end(),2);
   Set1.insert(Set1.end(),1);
   Set1.insert(Set1.end(),12);
   Set1.insert(Set1.end(),5);

   Set2.insert(Set2.end(),10);
   Set2.insert(Set2.end(),5);
   Set2.insert(Set2.end(),2);
   Set2.insert(Set2.end(),20);
   Set2.insert(Set2.end(),24);

   cout<<"Set 1"<<endl;
   copy(Set1.begin(),Set1.end(), out_stream), cout << endl;
   cout<<"Set 2"<<endl;
   copy(Set2.begin(),Set2.end(), out_stream), cout << endl;

   sort(Set1.begin(),Set1.end());
   cout<<"Set 1 Sorted"<<endl;
   copy(Set1.begin(),Set1.end(), out_stream), cout << endl;

   sort(Set2.begin(),Set2.end());
   cout<<"Set 2 Sorted"<<endl;
   copy(Set2.begin(),Set2.end(), out_stream), cout << endl;

 
   set_union(Set1.begin(),Set1.end(),Set2.begin(),Set2.end(), insert_iterator<IVec>(Output,Output.begin()));
   cout<<"Union"<<endl;
   copy(Output.begin(),Output.end(), out_stream), cout << endl;

   Output.erase(Output.begin(), Output.end());

   set_intersection(Set1.begin(),Set1.end(),Set2.begin(),Set2.end(), insert_iterator<IVec>(Output,Output.begin()));
   cout<<"Intersection"<<endl;
   copy(Output.begin(),Output.end(), out_stream), cout << endl;

   Output.erase(Output.begin(), Output.end());

   set_difference(Set1.begin(),Set1.end(),Set2.begin(),Set2.end(), insert_iterator<IVec>(Output,Output.begin()));
   cout<<"Difference Set1 <-> Set2"<<endl;
   copy(Output.begin(),Output.end(), out_stream), cout << endl;

   Output.erase(Output.begin(), Output.end());

   set_difference(Set2.begin(),Set2.end(),Set1.begin(),Set1.end(), insert_iterator<IVec>(Output,Output.begin()));
   cout<<"Difference Set2 <-> Set1"<<endl;
   copy(Output.begin(),Output.end(), out_stream), cout << endl;

}
