//-------------------------------------------------------------------------
// The following is part of the VIOWIN user-interface library source code.
// The code is copyright (c) 1994-1995 by Larry Salomon, Jr. and may not
// be used in a for-profit application without the expressed, written
// consent of Larry Salomon, Jr.  All rights reserved.
//-------------------------------------------------------------------------
#define INCL_VIO
#include "vwdefs.h"

BOOL EXPENTRY vwCreateCursor(HVWWND hwndWnd,
                             SHORT sX,
                             SHORT sY,
                             USHORT usCx,
                             USHORT usCy,
                             USHORT usFlags)
//-------------------------------------------------------------------------
// This function creates an underline cursor (the only one supported),
// or changes the position of the cursor, if CURSOR_SETPOS is specified
// in usFlags.  The cursor is initially hidden, if it is being created.
//
// Input:  hwndWnd - handle to the window to own the cursor
//         sX, sY - specifies the coordinates of the cursor in window
//                  coordinates
//         usCx, usCy - not used
//         usFlags - flags.  Only CURSOR_SETPOS is supported.
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   struct _VIOCURSORINFO vciCursor;
   BYTE abAttr[2];
   USHORT usSzAttr;

   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   //----------------------------------------------------------------------
   // If we are creating the cursor (i.e. CURSOR_SETPOS was not
   // specified), initialize the cursor such that it "belongs" to
   // the specified window.
   //----------------------------------------------------------------------
   if ((usFlags & CURSOR_SETPOS)==0) {
      habAnchor->pciCursor->hwndWnd=hwndWnd;
      habAnchor->usCursorState=0;
      vwShowCursor(hwndWnd,FALSE);
   } /* endif */

   //----------------------------------------------------------------------
   // This test will only be true if the window tried to call
   // CURSOR_SETPOS without creating the cursor first.
   //----------------------------------------------------------------------
   if (habAnchor->pciCursor->hwndWnd!=hwndWnd) {
      return FALSE;
   } /* endif */

   habAnchor->pciCursor->sX=sX;
   habAnchor->pciCursor->sY=sY;
   habAnchor->pciCursor->usCx=usCx;
   habAnchor->pciCursor->usCy=usCy;
   habAnchor->pciCursor->usFlags=usFlags;

   //----------------------------------------------------------------------
   // If the cursor is visible (i.e. not clipped), show it.
   //----------------------------------------------------------------------
   if ((habAnchor->pciCursor->sX>-1) &&
       (habAnchor->pciCursor->sX<hwndWnd->swpSwp.ulCx) &&
       (habAnchor->pciCursor->sY>-1) &&
       (habAnchor->pciCursor->sY<hwndWnd->swpSwp.ulCy)) {
      habAnchor->usCursorState&=~VWCS_CLIPPED;

      //-------------------------------------------------------------------
      // Set the position of the cursor
      //-------------------------------------------------------------------
      VioSetCurPos(vwQuerySysValue(VWSV_CYSCREEN)-1-
                      hwndWnd->swpSwp.lY-habAnchor->pciCursor->sY,
                   hwndWnd->swpSwp.lX+habAnchor->pciCursor->sX,
                   NULLHANDLE);

      //-------------------------------------------------------------------
      // Set the attribute to be the inverse of what's on the screen at
      // the cursor position now
      //-------------------------------------------------------------------
      usSzAttr=sizeof(abAttr);

      VioReadCellStr(abAttr,
                     &usSzAttr,
                     vwQuerySysValue(VWSV_CYSCREEN)-1-
                        hwndWnd->swpSwp.lY-habAnchor->pciCursor->sY,
                     hwndWnd->swpSwp.lX+habAnchor->pciCursor->sX,
                     NULLHANDLE);

      VioGetCurType(&vciCursor,NULLHANDLE);
      vciCursor.attr=abAttr[1] ^ 0xFF;
      VioSetCurType(&vciCursor,NULLHANDLE);
   } else {
      habAnchor->usCursorState|=VWCS_CLIPPED;

      VioGetCurType(&vciCursor,NULLHANDLE);
      vciCursor.attr=-1;
      VioSetCurType(&vciCursor,NULLHANDLE);
   } /* endif */

   return TRUE;
}

BOOL EXPENTRY vwDestroyCursor(HVWWND hwndWnd)
//-------------------------------------------------------------------------
// This function destroys the cursor.
//
// Input:  hwndWnd - handle to the window owning the cursor
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   if (!vwShowCursor(hwndWnd,FALSE)) {
      return FALSE;
   } /* endif */

   habAnchor->pciCursor->hwndWnd=NULL;
   return TRUE;
}

BOOL EXPENTRY vwShowCursor(HVWWND hwndWnd,BOOL bShow)
//-------------------------------------------------------------------------
// This function shows or hides the cursor.
//
// Input:  hwndWnd - handle to the window owning the cursor
//         bShow - specifies whether to show or hide the cursor
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   struct _VIOCURSORINFO vciCursor;

   if (!vwIsWindow(hwndWnd)) {
      return FALSE;
   } /* endif */

   if (hwndWnd!=habAnchor->pciCursor->hwndWnd) {
      return FALSE;
   } /* endif */

   if (bShow) {
      habAnchor->usCursorState|=VWCS_VISIBLE;

      if ((habAnchor->usCursorState & VWCS_CLIPPED)==0) {
         VioGetCurType(&vciCursor,NULLHANDLE);
         vciCursor.attr=0;
         VioSetCurType(&vciCursor,NULLHANDLE);
      } /* endif */
   } else {
      habAnchor->usCursorState&=~VWCS_VISIBLE;

      VioGetCurType(&vciCursor,NULLHANDLE);
      vciCursor.attr=-1;
      VioSetCurType(&vciCursor,NULLHANDLE);
   } /* endif */

   return TRUE;
}

BOOL EXPENTRY vwQueryCursorInfo(PVWCURSORINFO pciInfo)
//-------------------------------------------------------------------------
// This function returns information about the cursor.
//
// Input:  pciInfo - points to a VWCURSORINFO structure to receive the
//                   result
// Output:  pciInfo - points to the initialized VWCURSORINFO structure
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   if (hmqQueue==NULL) {
      return FALSE;
   } /* endif */

   *pciInfo=*habAnchor->pciCursor;
   pciInfo->usFlags&=~CURSOR_SETPOS;
   return TRUE;
}
