#define INCL_WINDIALOGS
#define INCL_WINENTRYFIELDS
#define INCL_WININPUT
#define INCL_WINMESSAGEMGR
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <viowin.h>
#include "cl.h"

typedef struct _INSTDATA {
   ULONG ulSzStruct;

   BOOL bChanged;
   BOOL bDirty;
   BOOL bSetParms;

   SHORT sAnchor;
   SHORT sCursor;

   SHORT sFirstChar;

   PCHAR pchBuf;
   USHORT usSzBuf;
} INSTDATA, *PINSTDATA;

BOOL scrollText(HVWWND hwndWnd,BOOL bLeft)
//-------------------------------------------------------------------------
// This function scrolls the text left or right by half the window's
// width.
//
// Input:  hwndWnd - handle to the window
//         bLeft - TRUE if scroll goes to the left, FALSE if to the right
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;
   RECTL rclWnd;

   //----------------------------------------------------------------------
   // Get the instance data and the window rectangle
   //----------------------------------------------------------------------
   pidData=vwQueryWindowPtr(hwndWnd,1);

   vwQueryWindowRect(hwndWnd,&rclWnd);
   rclWnd.xRight--;
   rclWnd.yTop--;

   //----------------------------------------------------------------------
   // Calculate the new first character
   //----------------------------------------------------------------------
   if (bLeft) {
      pidData->sFirstChar-=(rclWnd.xRight-rclWnd.xLeft)/2;
   } else {
      pidData->sFirstChar+=(rclWnd.xRight-rclWnd.xLeft)/2;
   } /* endif */

   //----------------------------------------------------------------------
   // Do boundary checks
   //----------------------------------------------------------------------
   if (pidData->sFirstChar<0) {
      pidData->sFirstChar=0;
   } /* endif */

   if (pidData->sFirstChar>strlen(pidData->pchBuf)-1) {
      pidData->sFirstChar=strlen(pidData->pchBuf)-1;
   } /* endif */

   //----------------------------------------------------------------------
   // Paint and notify the owner
   //----------------------------------------------------------------------
   vwSendMsg(hwndWnd,WM_PAINT,0,0);

   vwSendMsg(VWHWND_DESKTOP,
             WM_CONTROL,
             MPFROM2SHORT(vwQueryWindowUShort(hwndWnd,QWS_ID),
                          EN_SCROLL),
             MPFROMHWND(hwndWnd));

   return TRUE;
}

BOOL deltaCursor(HVWWND hwndWnd,BOOL bLeft)
//-------------------------------------------------------------------------
// This function moves the cursor one character to the left or right
//
// Input:  hwndWnd - handle to the window
//         bLeft - TRUE if cursor goes to the left, FALSE if to the right
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;
   RECTL rclWnd;

   //----------------------------------------------------------------------
   // Get the instance data and the window rectangle
   //----------------------------------------------------------------------
   pidData=vwQueryWindowPtr(hwndWnd,1);

   vwQueryWindowRect(hwndWnd,&rclWnd);
   rclWnd.xRight--;
   rclWnd.yTop--;

   if (bLeft) {
      //-------------------------------------------------------------------
      // Check to see if we're already at the beginning
      //-------------------------------------------------------------------
      if (pidData->sCursor>0) {
         pidData->sCursor--;

         //----------------------------------------------------------------
         // If the cursor went beyond the left edge, scroll the window
         //----------------------------------------------------------------
         if (pidData->sCursor<pidData->sFirstChar) {
            scrollText(hwndWnd,TRUE);
         } /* endif */

         //----------------------------------------------------------------
         // Update the cursor position
         //----------------------------------------------------------------
         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);

         return TRUE;
      } else {
         vwAlarm(WA_ERROR);
         return FALSE;
      } /* endif */
   } else {
      //-------------------------------------------------------------------
      // Check to see if we're already at the end
      //-------------------------------------------------------------------
      if (pidData->sCursor<strlen(pidData->pchBuf)) {
         pidData->sCursor++;

         //----------------------------------------------------------------
         // If the cursor went beyond the right edge, scroll the window
         //----------------------------------------------------------------
         if (pidData->sCursor>pidData->sFirstChar+rclWnd.xRight-2) {
            scrollText(hwndWnd,FALSE);
         } /* endif */

         //----------------------------------------------------------------
         // Update the cursor position
         //----------------------------------------------------------------
         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);

         return TRUE;
      } else {
         vwAlarm(WA_ERROR);
         return FALSE;
      } /* endif */
   } /* endif */
}

VOID textChanged(HWND hwndWnd)
//-------------------------------------------------------------------------
// This function simply performs a common task of setting the changed
// and dirty flags and sending the owner a changed notification.
//
// Input:  hwndWnd - handle to the window
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;

   pidData=vwQueryWindowPtr(hwndWnd,1);

   pidData->bChanged=TRUE;
   pidData->bDirty=TRUE;

   vwSendMsg(VWHWND_DESKTOP,
             WM_CONTROL,
             MPFROM2SHORT(vwQueryWindowUShort(hwndWnd,QWS_ID),EN_CHANGE),
             MPFROMHWND(hwndWnd));
}

BOOL handleVkey(struct _CHARMSG *pcmMsg,HVWWND hwndWnd)
//-------------------------------------------------------------------------
// This function processes the virtual keystrokes.
//
// Input:  pcmMsg - points to the CHARMSG structure
//         hwndWnd - handle to the window
//
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;
   RECTL rclWnd;
   ULONG ulMods;
   ULONG ulIndex;

   //----------------------------------------------------------------------
   // Get the instance data and the window rectangle
   //----------------------------------------------------------------------
   pidData=vwQueryWindowPtr(hwndWnd,1);

   vwQueryWindowRect(hwndWnd,&rclWnd);
   rclWnd.xRight--;
   rclWnd.yTop--;

   ulMods=KC_CTRL | KC_ALT | KC_SHIFT;

   //----------------------------------------------------------------------
   // Check for Control or Alt or Shift key down
   //----------------------------------------------------------------------
   switch (pcmMsg->fs & ulMods) {
   case 0:
      //-------------------------------------------------------------------
      // None of them were down
      //-------------------------------------------------------------------
      switch (pcmMsg->vkey) {
      case VK_LEFT:
         //----------------------------------------------------------------
         // Move the cursor
         //----------------------------------------------------------------
         if (!deltaCursor(hwndWnd,TRUE)) {
            return FALSE;
         } /* endif */
         break;
      case VK_RIGHT:
         //----------------------------------------------------------------
         // Move the cursor
         //----------------------------------------------------------------
         if (!deltaCursor(hwndWnd,FALSE)) {
            return FALSE;
         } /* endif */
         break;
      case VK_BACKSPACE:
         {
            PCHAR pchFirst;

            //-------------------------------------------------------------
            // Move the cursor and move the text in the buffer to the
            // left one character, effectively erasing the current
            // character
            //-------------------------------------------------------------
            if (deltaCursor(hwndWnd,TRUE)) {
               pchFirst=&pidData->pchBuf[pidData->sCursor];
               strcpy(pchFirst,pchFirst+1);

               vwSendMsg(hwndWnd,WM_PAINT,0,0);
               textChanged(hwndWnd);
            } else {
               return FALSE;
            } /* endif */
         }
         break;
      case VK_INSERT:
         //----------------------------------------------------------------
         // Toggle the insertion mode
         //----------------------------------------------------------------
         vwSendMsg(hwndWnd,
                   EM_SETINSERTMODE,
                   MPFROMLONG(!vwQuerySysValue(VWSV_INSERTMODE)),
                   0);
         break;
      case VK_DELETE:
         {
            PCHAR pchFirst;

            //-------------------------------------------------------------
            // Move the cursor and move the text in the buffer to the
            // left one character, effectively erasing the character
            // to the right of the cursor
            //-------------------------------------------------------------
            if (pidData->sCursor<strlen(pidData->pchBuf)) {
               pchFirst=&pidData->pchBuf[pidData->sCursor];
               strcpy(pchFirst,pchFirst+1);

               vwSendMsg(hwndWnd,WM_PAINT,0,0);
               textChanged(hwndWnd);
            } else {
               vwAlarm(WA_ERROR);
               return FALSE;
            } /* endif */
         }
         break;
      case VK_SPACE:
         if (pidData->sCursor<pidData->usSzBuf) {
            //-------------------------------------------------------------
            // Insert a space or overwrite the current character with a
            // space
            //-------------------------------------------------------------
            if (vwQuerySysValue(VWSV_INSERTMODE)) {
               if (strlen(pidData->pchBuf)<pidData->usSzBuf) {
                  for (ulIndex=strlen(pidData->pchBuf)+1;
                       ulIndex>pidData->sCursor;
                       ulIndex--) {
                      pidData->pchBuf[ulIndex]=pidData->pchBuf[ulIndex-1];
                  } /* endfor */
               } else {
                  vwAlarm(WA_ERROR);
                  return FALSE;
               } /* endif */
            } /* endif */

            pidData->pchBuf[pidData->sCursor]=' ';
            deltaCursor(hwndWnd,FALSE);

            vwSendMsg(hwndWnd,WM_PAINT,0,0);
            textChanged(hwndWnd);
         } else {
            vwAlarm(WA_ERROR);
            return FALSE;
         } /* endif */
         break;
      case VK_HOME:
         //----------------------------------------------------------------
         // Move the cursor to the first position
         //----------------------------------------------------------------
         pidData->sFirstChar=0;
         pidData->sCursor=pidData->sFirstChar;

         vwSendMsg(hwndWnd,WM_PAINT,0,0);

         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);
         break;
      case VK_END:
         //----------------------------------------------------------------
         // Move the cursor to the last position
         //----------------------------------------------------------------
         pidData->sCursor=strlen(pidData->pchBuf)-1;
         pidData->sFirstChar=pidData->sCursor-(rclWnd.xRight-rclWnd.xLeft)/2;

         if (pidData->sFirstChar<0) {
            pidData->sFirstChar=0;
         } /* endif */

         vwSendMsg(hwndWnd,WM_PAINT,0,0);

         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);
         break;
      default:
         return FALSE;
      } /* endswitch */
      break;
   case KC_CTRL:
      //-------------------------------------------------------------------
      // Control key was down
      //-------------------------------------------------------------------
      switch (pcmMsg->vkey) {
      case VK_LEFT:
         //----------------------------------------------------------------
         // Ctrl-Left is the same as "home"
         //----------------------------------------------------------------
         pidData->sCursor=0;
         pidData->sFirstChar=pidData->sCursor;

         vwSendMsg(hwndWnd,WM_PAINT,0,0);

         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);
         break;
      case VK_RIGHT:
         //----------------------------------------------------------------
         // Ctrl-Right is the same as "end"
         //----------------------------------------------------------------
         pidData->sFirstChar=strlen(pidData->pchBuf)-1;
         pidData->sCursor=pidData->sFirstChar;

         vwSendMsg(hwndWnd,WM_PAINT,0,0);

         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);
         break;
      default:
         return FALSE;
      } /* endswitch */
      break;
   default:
      return FALSE;
   } /* endswitch */

   return TRUE;
}

BOOL handleChr(struct _CHARMSG *pcmMsg,HVWWND hwndWnd)
//-------------------------------------------------------------------------
// This function processes the non-virtual keystrokes.
//
// Input:  pcmMsg - points to the CHARMSG structure
//         hwndWnd - handle to the window
//
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;
   ULONG ulMods;
   ULONG ulIndex;

   pidData=vwQueryWindowPtr(hwndWnd,1);
   ulMods=KC_CTRL | KC_ALT | KC_SHIFT;

   switch (pcmMsg->fs & ulMods) {
   case 0:
   case KC_SHIFT:
      if (pidData->sCursor<pidData->usSzBuf) {
         //----------------------------------------------------------------
         // Insert the character or overwrite the current character with
         // the character
         //----------------------------------------------------------------
         if (vwQuerySysValue(VWSV_INSERTMODE)) {
            if (strlen(pidData->pchBuf)<pidData->usSzBuf) {
               for (ulIndex=strlen(pidData->pchBuf)+1;
                    ulIndex>pidData->sCursor;
                    ulIndex--) {
                   pidData->pchBuf[ulIndex]=pidData->pchBuf[ulIndex-1];
               } /* endfor */
            } else {
               vwAlarm(WA_ERROR);
               return FALSE;
            } /* endif */
         } /* endif */

         pidData->pchBuf[pidData->sCursor]=pcmMsg->chr;
         deltaCursor(hwndWnd,FALSE);
         vwSendMsg(hwndWnd,WM_PAINT,0,0);
         textChanged(hwndWnd);

         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        CURSOR_SETPOS);
      } else {
         vwAlarm(WA_ERROR);
         return FALSE;
      } /* endif */
      break;
   default:
      return FALSE;
   } /* endswitch */

   return TRUE;
}

MRESULT EXPENTRY VwEntryfieldClassProc(HVWWND hwndWnd,
                                       ULONG ulMsg,
                                       MPARAM mpParm1,
                                       MPARAM mpParm2)
{
   PINSTDATA pidData;

   pidData=vwQueryWindowPtr(hwndWnd,1);

   switch (ulMsg) {
   case WM_CREATE:
      //-------------------------------------------------------------------
      // Allocate and initialize the instance data
      //-------------------------------------------------------------------
      pidData=calloc(1,sizeof(INSTDATA));
      if (pidData==NULL) {
         return MRFROMSHORT(TRUE);
      } /* endif */

      vwSetWindowPtr(hwndWnd,1,pidData);

      pidData->ulSzStruct=sizeof(pidData);

      pidData->bChanged=FALSE;
      pidData->bDirty=FALSE;
      pidData->bSetParms=FALSE;
      pidData->sAnchor=0;
      pidData->sCursor=0;
      pidData->sFirstChar=0;
      pidData->pchBuf=NULL;
      pidData->usSzBuf=0;

      vwSendMsg(hwndWnd,EM_SETTEXTLIMIT,MPFROMSHORT(32),0);
      break;
   case WM_DESTROY:
      free(pidData);
      break;
   case WM_PAINT:
      {
         RECTL rclWnd;
         CHAR achText[256];
         ULONG ulFore;
         ULONG ulBack;
         PCHAR pchFirst;
         USHORT usLenVisible;
         ULONG ulStyle;

         //----------------------------------------------------------------
         // Get the window rectangle
         //----------------------------------------------------------------
         vwQueryWindowRect(hwndWnd,&rclWnd);
         rclWnd.xRight--;
         rclWnd.yTop--;

         //----------------------------------------------------------------
         // Initialize the buffer that we will draw to "show" ourselves
         //----------------------------------------------------------------
         memset(achText,' ',sizeof(achText));
         achText[sizeof(achText)-1]=0;

         //----------------------------------------------------------------
         // Get the colors and toggle them if we have the focus
         //----------------------------------------------------------------
         ulFore=vwQueryForeColor(hwndWnd);
         ulBack=vwQueryBackColor(hwndWnd);

         if (vwQueryFocus()==hwndWnd) {
            ulFore^=0x000000FF;
            ulBack^=0x000000FF;
         } /* endif */

         //----------------------------------------------------------------
         // Put the brackets in the buffer
         //----------------------------------------------------------------
         achText[0]='[';
         achText[rclWnd.xRight]=']';

         //----------------------------------------------------------------
         // Copy the text to the buffer.  If unreadable, set the
         // text in the buffer to '*'.
         //----------------------------------------------------------------
         pchFirst=&pidData->pchBuf[pidData->sFirstChar];
         usLenVisible=min(rclWnd.xRight-2,strlen(pchFirst));

         ulStyle=vwQueryWindowULong(hwndWnd,QWL_STYLE);

         if ((ulStyle & ES_UNREADABLE)!=0) {
            memset(&achText[1],'*',usLenVisible);
         } else {
            memcpy(&achText[1],pchFirst,usLenVisible);
         } /* endif */

         vwDrawText(hwndWnd,
                    -1,
                    achText,
                    NULL,
                    ulFore,
                    ulBack,
                    DT_LEFT|DT_TOP|DT_ERASERECT);
      }
      break;
   case WM_CHAR:
      {
         ULONG ulFlags;

         ulFlags=KC_KEYUP;

         if ((CHARMSG(&ulMsg)->fs & ulFlags)!=0) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         if ((CHARMSG(&ulMsg)->fs & KC_VIRTUALKEY)!=0) {
            if (!handleVkey(CHARMSG(&ulMsg),hwndWnd)) {
               return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
            } /* endif */
         } else {
            if (!handleChr(CHARMSG(&ulMsg),hwndWnd)) {
               return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
            } /* endif */
         } /* endif */
      }
      return MRFROMSHORT(TRUE);
   case WM_QUERYDLGCODE:
      return MRFROMLONG(DLGC_ENTRYFIELD);
   case WM_SETFOCUS:
      if (SHORT1FROMMP(mpParm2)) {
         vwSendMsg(VWHWND_DESKTOP,
                   WM_CONTROL,
                   MPFROM2SHORT(vwQueryWindowUShort(hwndWnd,QWS_ID),
                                EN_SETFOCUS),
                   MPFROMHWND(hwndWnd));

         vwCreateCursor(hwndWnd,
                        pidData->sCursor-pidData->sFirstChar+1,
                        0,
                        1,
                        1,
                        0);
         vwShowCursor(hwndWnd,TRUE);
      } else {
         vwSendMsg(VWHWND_DESKTOP,
                   WM_CONTROL,
                   MPFROM2SHORT(vwQueryWindowUShort(hwndWnd,QWS_ID),
                                EN_KILLFOCUS),
                   MPFROMHWND(hwndWnd));

         vwShowCursor(hwndWnd,FALSE);
         vwDestroyCursor(hwndWnd);
      } /* endif */
      break;
   case WM_SETWINDOWPARAMS:
      {
         PWNDPARAMS pwpParms;
         MRESULT mrRc;

         pwpParms=(PWNDPARAMS)PVOIDFROMMP(mpParm1);

         mrRc=vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);

         //----------------------------------------------------------------
         // This is the tricky part:
         //
         // If the application calls vwSetWindowText(), then we want to
         // execute normally.  However, WM_QUERYWINDOWPARAMS calls
         // vwSetWindowText() whenever the "dirty" flag is set, so
         // we don't want to do this processing in that case.
         //----------------------------------------------------------------
         if ((pwpParms->fsStatus==WPM_TEXT) && (!pidData->bSetParms)) {
            *pidData->pchBuf=0;
            strncat(pidData->pchBuf,pwpParms->pszText,pidData->usSzBuf-1);

            if (pidData->usSzBuf<pwpParms->cchText) {
               pidData->bDirty=TRUE;
            } else {
               pidData->bDirty=FALSE;
            } /* endif */

            pidData->bChanged=TRUE;
            pidData->sCursor=0;
            pidData->sFirstChar=0;

            vwSendMsg(hwndWnd,WM_PAINT,0,0);
         } /* endif */

         return mrRc;
      }
   case WM_QUERYWINDOWPARAMS:
      {
         PWNDPARAMS pwpParms;

         pwpParms=(PWNDPARAMS)PVOIDFROMMP(mpParm1);

         switch (pwpParms->fsStatus) {
         case WPM_CCHTEXT:
         case WPM_TEXT:
            //-------------------------------------------------------------
            // If we're "dirty", set bSetParms to TRUE and call
            // vwSetWindowText() to synch VIOWIN's version of our
            // text with our own copy.
            //-------------------------------------------------------------
            if (pidData->bDirty) {
               pidData->bSetParms=TRUE;
               vwSetWindowText(hwndWnd,pidData->pchBuf);
               pidData->bSetParms=FALSE;

               pidData->bDirty=FALSE;
            } /* endif */
            break;
         default:
            break;
         } /* endswitch */

         return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      }
   case EM_QUERYCHANGED:
      {
         BOOL bChanged;

         bChanged=pidData->bChanged;
         pidData->bChanged=FALSE;
         return MRFROMSHORT(bChanged);
      }
   case EM_QUERYSEL:
      break;
   case EM_SETSEL:
      break;
   case EM_SETTEXTLIMIT:
      {
         PCHAR pchBuf;

         //----------------------------------------------------------------
         // Allocate a new buffer, free the current one, and set
         // pidData->pchBuf to the new buffer
         //----------------------------------------------------------------
         pchBuf=calloc(1,SHORT1FROMMP(mpParm1)+1);
         if (pchBuf==NULL) {
            return MRFROMSHORT(FALSE);
         } /* endif */

         if (pidData->pchBuf!=NULL) {
            *pchBuf=0;
            strncat(pchBuf,pidData->pchBuf,SHORT1FROMMP(mpParm1));

            free(pidData->pchBuf);
         } /* endif */

         pidData->pchBuf=pchBuf;
         pidData->usSzBuf=SHORT1FROMMP(mpParm1);
         return MRFROMSHORT(TRUE);
      }
   case EM_CUT:
      break;
   case EM_COPY:
      break;
   case EM_PASTE:
      break;
   case EM_QUERYFIRSTCHAR:
      return MRFROMSHORT(pidData->sFirstChar);
   case EM_SETFIRSTCHAR:
      {
         SHORT sFirstChar;

         sFirstChar=SHORT1FROMMP(mpParm1);
         if ((sFirstChar>0) && (sFirstChar<strlen(pidData->pchBuf))) {
            pidData->sFirstChar=sFirstChar;
            return MRFROMSHORT(TRUE);
         } else {
            return MRFROMSHORT(FALSE);
         } /* endif */
      }
   case EM_QUERYREADONLY:
      {
         ULONG ulStyle;

         ulStyle=vwQueryWindowULong(hwndWnd,QWL_STYLE);
         return MRFROMSHORT((ulStyle & ES_READONLY)!=0);
      }
   case EM_SETREADONLY:
      {
         ULONG ulStyle;

         ulStyle=vwQueryWindowULong(hwndWnd,QWL_STYLE);
         ulStyle=ulStyle & (~ES_READONLY) |
                    (SHORT1FROMMP(mpParm1) ? ES_READONLY : 0);
         vwSetWindowULong(hwndWnd,QWL_STYLE,ulStyle);
         return MRFROMSHORT(TRUE);
      }
   case EM_SETINSERTMODE:
      {
         BOOL bInsert;

         bInsert=(SHORT1FROMMP(mpParm1)!=0);
         vwSetSysValue(VWSV_INSERTMODE,bInsert);
      }
      break;
   default:
      return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMLONG(FALSE);
}
