/***************************************************************************
 *
 * MODULE:	Common functions of RMX starter applications.
 * SOURCE:	$Source$
 * OVERVIEW:	This file contains the implementation of functions
 *              that are used by both rmxstrtr.exe and rmxstart.exe 
 *
 * Copyright (c) 1995 Johan Wikman (johan.wikman@ntc.nokia.com)
 *
 * $Log$
 *
 ****************************************************************************/

#define INCL_NOCOMMON
#define INCL_DOSERRORS
#define INCL_DOSFILEMGR
#include <rmxstart.h>
#include <rmxcomms.h>

#include <iostream.h>
#include <stdlib.h>
#include <os2.h>


/****************************************************************************
 * MODULE VARIABLES
 ****************************************************************************/

const PCSZ RMXSTARTER = "rmxstarter";


/****************************************************************************
 *
 * FUNCTION: PSZ GetStarterName();
 *
 * RETURN:
 *    The name to use when creating the starter connection or NULL if
 *    something fails.
 *
 * OVERVIEW:
 *    We do not know (nor are we interested in knowing) what the actual
 *    name is.
 *
 ****************************************************************************/

PSZ GetStarterName()
{
  PSZ
    pszName = 0;
  ULONG
    ulSize = CCHMAXPATH,
    rc;

  // Get the name we should listen to.

  do
    {
      pszName = new CHAR [ulSize];

      rc = RmxGetServiceName(RMXSTARTER, &ulSize, pszName);
      
      if (rc == RMXERR_ENLARGE_BUFFER)
	delete [] pszName;
    }
  while (rc == RMXERR_ENLARGE_BUFFER);
  
  if (rc != NO_ERROR)
    {
      delete [] pszName;
      pszName = 0;
    }

  return pszName;
}


/****************************************************************************
 *
 * FUNCTION: VOID OutOfMem();
 *
 * OVERVIEW:
 *    This function is called when an allocation request fails. An
 *    error message is printed to stderr, and the application is
 *    terminated. It is assumed that iostream does not need to
 *    allocate mamory from the heap.
 *
 ****************************************************************************/

VOID OutOfMem()
{
  cerr << "Failed to allocate memory, terminating application." << endl;
  ::exit(EXIT_RESOURCE);
}
