#include <stdlib.h>
#include <somd.xh>
#include "SomTerm.xh"


#define checkEv(ev) ((ev)->_major != NO_EXCEPTION)

int main(int argc, char *argv[]){
    Environment *ev;
    SomTerm *TermObj;

    /* local and DSOM initialization */
    ev = SOM_CreateLocalEnvironment();
    SOMD_Init(ev);

    TermObj = (SomTerm *) SOMD_ObjectMgr->somdNewObject(ev, "SomTerm", NULL);

    if (checkEv(ev))
    {
      SOMD_Uninit(ev);
      SOM_DestroyLocalEnvironment(ev);
      exit(1);
    }

   TermObj->DisplayString(ev,"Test");
   TermObj->MoveCursor(ev,1,0);
   TermObj->_set_ForeGroundColor(ev,3);
   TermObj->DisplayString(ev,"Enter a String");
   TermObj->MoveCursor(ev,2,0);
   char* Line=TermObj->GetLine(ev);
   TermObj->MoveCursor(ev,3,0);
   TermObj->DisplayString(ev,Line);
   ORBfree(Line);

    SOMD_Uninit(ev);
    SOM_DestroyLocalEnvironment(ev);
    return 0;
}
