#include "MemObj.h"
#define INCL_DOSMEMMGR
#include <os2.h>

#include <string.h>


MemoryObj::MemoryObj(ULONG Len){
   BaseLen=Len;
   BaseAddr=0;
}


MemoryObj::~MemoryObj(){
   if(fIsSubInitialized)
      UnInitializeForSubAlloc();

   FreeBaseMem();
}



int MemoryObj::InitializeForSubAlloc(int IsServ, ULONG SubAllocPoolLen){
   ULONG Flag;
   int ret;

   if(!SubAllocPoolLen){
      if(BaseLen)
         SubAllocPoolLen=BaseLen;
   }


   MemoryObj::SubAllocPoolLen=SubAllocPoolLen;
 

   Flag=DOSSUB_SPARSE_OBJ;

   if(IsServ)
      Flag|=DOSSUB_INIT;
   if(IsShared())
      Flag|=DOSSUB_SERIALIZE;


   fIsSubInitialized=1;
   ret=DosSubSetMem(BaseAddr,Flag,SubAllocPoolLen);
   return !ret;
}


int MemoryObj::UnInitializeForSubAlloc(){
   int ret;

   ret=DosSubUnsetMem(BaseAddr);
   fIsSubInitialized=0;

return !ret;
}

void* MemoryObj::SubAlloc(ULONG Length){
   if(!fIsSubInitialized)
      return 0;

   void* Temp;
   int ret;

   ret=DosSubAllocMem(BaseAddr,&Temp,Length);

   if(ret)
      return 0;

   return Temp;
}

int MemoryObj::SubFree(void *Ptr, ULONG Lenght){
   if(!fIsSubInitialized)
      return 0;

   return !(DosSubFreeMem(BaseAddr,Ptr,Lenght));
}

int MemoryObj::FreeBaseMem(){
   return !(DosFreeMem(BaseAddr));
}




SharedMemoryObj::SharedMemoryObj(ULONG Len,char InitForSubAlloc,char *Name)
                  :MemoryObj(Len){
   int ret;

   if(Name){
      CreateName(Name);
      BaseAddr=AllocBaseMem(Len,1);
   }
   else
      MemoryName=0;

   if(InitForSubAlloc)
      InitializeForSubAlloc(1);

}

SharedMemoryObj::SharedMemoryObj(char *Name,ULONG Len,char InitForSubAlloc):MemoryObj(Len){

   CreateName(Name);
   OpenShareMem();
   

   if(InitForSubAlloc)
      InitializeForSubAlloc(0);

}

SharedMemoryObj::~SharedMemoryObj(){
   if(MemoryName)
      delete [] MemoryName;
}


void SharedMemoryObj::CreateName(char *Name){

   MemoryName=new char[strlen(Name)+20];

   strcpy(MemoryName,"\\SHAREMEM\\");
   strcat(MemoryName,Name);
 
}

void* SharedMemoryObj::AllocBaseMem(ULONG Len, int IsServ){
   int ret;

   ret=DosAllocSharedMem(&BaseAddr,MemoryName,Len,
         PAG_EXECUTE|PAG_READ|PAG_WRITE);

   if(ret)
      return 0;
   else
      return BaseAddr;
}


int SharedMemoryObj::OpenShareMem(){
   int ret;

   ret=DosGetNamedSharedMem(&BaseAddr,MemoryName,PAG_READ|PAG_WRITE|PAG_EXECUTE);

   return !ret;
}
