#ifndef _CONTAINER_H_
#define _CONTAINER_H_

#ifndef _FACTORYWINDOW_H_
#include <pm/FactoryWindow.h>
#endif

#ifndef _OS2TYPES_H_
#include <pm/OS2Types.h>
#endif

@interface Container : FactoryWindow <Archiving>
{
  ULONG              createFlags;
  CONTAINER_MINIREC *recordBuffer;
  FIELDINFO         *columnBuffer;
}

/*
 * Initializing an object
 */
- initWithId: (ULONG) anId andFlags: (ULONG) flags in: (Window *) parent;
- addColumn: (char *) aTitle;

/*
 * Inserting data
 */
- insertObject: anObject;
- insertObject: anObject withTitle: (char *) aTitle;
- insertObject: anObject withTitle: (char *) aTitle andIcon: (ULONG) anIcon;

-insertObjectList: aList;
-insertObjectList: aList withTitles: titleList;
-insertObjectList: aList withTitles: titleList andIcon: (ULONG) anIcon;

- insertObject: anObject parent: parentObject;
- insertObject: anObject withTitle: (char *) aTitle parent: parentObject;
- insertObject: anObject withTitle: (char *) aTitle andIcon: (ULONG) anIcon
        parent: parentObject;

/*
 * Set look & feel of object
 */
- arrange;
- iconView: sender;
- nameView: sender;
- textView: sender;
- treeView: sender;
- detailView: sender;

/*
 * Query contents
 */
- (ULONG) records;
- object;

- (CONTAINER_MINIREC *) findRecord: anObject;
- (CONTAINER_MINIREC *) firstRecord;
- (CONTAINER_MINIREC *) lastRecord;
- (CONTAINER_MINIREC *) nextRecord;
- (CONTAINER_MINIREC *) previousRecord;
- (CONTAINER_MINIREC *) childRecord;
- (CONTAINER_MINIREC *) parentRecord;
- (CONTAINER_MINIREC *) firstSelected;
- (CONTAINER_MINIREC *) nextSelected;
- (BOOL) recordIsSelected;

- objectWithTitle: (char *) aTitle;

- invalidateRecord;
- invalidateSelectedRecords;

- hideRecord : sender;
- hideSelectedRecords : sender;
- hideNotSelectedRecords : sender;
- showRecord : sender;
- showAllRecords : sender;
- (BOOL) recordIsHidden;

-removeAllColumns: sender;
-removeAllRecords: sender;
-removeSelectedRecords: sender;

/*
 * Query column information
 */
- (ULONG) columns;

- (FIELDINFO *) firstColumn;
- (FIELDINFO *) lastColumn;
- (FIELDINFO *) nextColumn;
- (FIELDINFO *) previousColumn;

- (char *) columnTitle;
- (ULONG) columnTitleAttributes;
- (ULONG) columnDataAttributes;

- hideColumn : sender;
- showColumn : sender;
- showAllColumns : sender;
- (BOOL) columnIsHidden;

- invalidateColumns;
- setColumnTitleAttributes: (ULONG) attr;
- setColumnDataAttributes: (ULONG) attr;

/*
 * selecting and deselecting
 */
- select;
- deselect;
- selectAll: sender;
- deselectAll: sender;

/*
 * Sorting the records
 */
- sort: (ULONG) column;
- sortByTitleWithCase: sender;
- sortByTitleWithoutCase: sender;

/*
 * Archiving the object
 */
- read: (TypedStream *) aStream;
- write: (TypedStream *) aStream;
- awake;

- createInPMWindow: (HWND) hwnd;

- (MRESULT) handleMessage: (ULONG) msg 
               withParams: (MPARAM) mp1 and: (MPARAM) mp2;

@end

SHORT compareColumn (CONTAINER_MINIREC *record1,
		     CONTAINER_MINIREC *record2,
		     ULONG column);

SHORT compareByTitle (CONTAINER_MINIREC *record1,
		      CONTAINER_MINIREC *record2,
		      ULONG caseSens);

#endif
