#ifndef _DBFIELD_H_
#define _DBFIELD_H_

#include <objc/Object.h>

#ifndef _DBTYPES_H_
#include "DBTypes.h"
#endif

#ifndef _PROPERTIES_H_
#include "DBProperties.h"
#endif

@interface DBField : Object <DBProperties>
{
   id <DBEntities>  entity;
   BOOL             isKey;
   BOOL             isReadOnly;
   const char      *propertyName;

   char             length,
                    decimals,
                   *stringValue,
                   *modifiedStringValue;

}

- initWithName: (const char *) aName andLength: (char) aLength 
   andDecimals: (char) someDecimals;
- free;
- setStringValue: (char *) aString;
- (char *) stringValue;
- (char) length;

-(int) compareWith: (char *) aString;

/* ------------------- Protocol "DBProperties" -------------------- */
-(id <DBEntities>) entity;
-(BOOL) isKey;
-(BOOL) isReadOnly;
-(BOOL) isSingular;
-(BOOL) matchesProperty: (id <DBProperties>) aProperty;
-(const char *) propertyName;
-propertyType;
-(BOOL) setName: (const char *) aName;

/* ----------------------- Private Methods ------------------------ */
-setEntity: (id <DBEntities>) anEntity;
-setIsKey: (BOOL) aFlag;
-setIsReadOnly: (BOOL) aFlag;

/* --------------------------- Copying ---------------------------- */
-copy;

@end

#endif

