/* -------------------------------------------------------------------

	Project: General utility classes

	Objective-C interface file for the class organizedfile

	COPYRIGHT (C), 1995, Thomas Baier
	ALL RIGHTS RESERVED.

	Date:				Rev: 0.1
	1995-Jul-17			___

 */

#ifndef _ORGANIZEDFILE_H_
#define _ORGANIZEDFILE_H_
/*====================================================================
                   Interface of class organizedfile                   
====================================================================*/
#include <util/File.h>

/*
 * This structure is used to maintain a list of all free pages in the
 * data file. The first free list page is the first page in the file.
 * In this case, the variable prevPage points to the actual root page of
 * the data file.
 */
typedef struct _FREELIST {
  long prevPage;
  long nextPage;
  long count;
  long pages[0];
} FREELIST;

@interface OrganizedFile : File
{
  FREELIST *freeList;
  long      freePage;
  long      rootPage;
}

/* -------------------------- Initialize -------------------------- */
-init;
-initForReading: (char *) string recordSize: (long) aRecSize;
-initForWriting: (char *) string recordSize: (long) aRecSize;
-createForWriting: (char *) string recordSize: (long) aRecSize;

/* ----------------------------- Free ----------------------------- */
-free;

/* ----------- Methods for access to Instance Variables ----------- */
-setRootPage: (long) aPage;
-(long) rootPage;

/* ------------------------ Public methods ------------------------ */
-(long) append: (void *) record;
-(long) delete;
-(long) delete: (long) index;

/* ----------------------- Private methods ------------------------ */

@end
#endif
