/*
 * Objective C visual development package installation script
 */

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

Arg drive rest

call SysCls
say 'Objective C Visual development package - Installation'
say '-----------------------------------------------------'
say ''

if (LENGTH(drive) <> 1) THEN DO
	drive = 'c';
	Say 'No drive was specified, assuming drive C:';
END; Else
	Say 'Development package is installed on drive 'drive':'

Say ''
say 'Creating folder object and program objects...'
say ''

currentdir = directory()

if (\ SysSetObjectData(drive':\usr\lib\templates\Objc_Prj',,
	'ICONFILE='drive':\usr\lib\icons\objcprj.ico;',
	';ICONNFILE=1,'drive':\usr\lib\icons\objcprjo.ico',
	';TEMPLATE=YES')) THEN DO
	say "Error setting template data"
	say "Exiting..."
	Exit
END; Else
	say "Template data set successfully"

if (\ SysCreateObject('WPFolder',,
	'Visual Development',,
	'<WP_DESKTOP>',,
	'OBJECTID=<OBJC_VISDEV_FOLDER>;',
	';ICONFILE='drive':\usr\lib\icons\visdev.ico;',
	';ICONNFILE=1,'drive':\usr\lib\icons\visdevo.ico',,
	'replace')) THEN DO
	say "Error creating Folder 'Visual Development'"
	say "Exiting..."
	Exit
END; Else
	say "Folder Object 'Visual Development' was created"

if (\ SysCreateObject('WPProgram',,
	'Interface Editor',,
	'<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME='drive':\usr\bin\PM\IB.exe;',
		'OBJECTID=<OBJC_VISDEV_IB_PROGRAM_OBJECT>;',
		';ASSOCFILTER=*.oib',,
	'replace')) THEN DO
	say "	Creating 'Interface Editor' object failed"
	say "Exiting..."
	Exit
END; Else
	say "	Program Object for 'Interface Editor' was created"

if (\ SysCreateObject('WPProgram',,
	'Project Editor',,
	'<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME='drive':\usr\bin\PM\PB.exe;',
		'OBJECTID=<OBJC_VISDEV_PB_PROGRAM_OBJECT>;',
		';ASSOCFILTER=*.prj',,
	'replace')) THEN DO
	say "	Creating 'Project Editor' object failed"
	say "Exiting..."
	Exit
END; Else
	say "	Program Object for 'Project Editor' was created"

if (\ SysCreateObject('WPProgram',,
	'Database Editor',,
	'<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME='drive':\usr\bin\PM\DBEdit.exe;',
		'OBJECTID=<OBJC_VISDEV_DBB_PROGRAM_OBJECT>;',,
	'replace')) THEN DO
	say "	Creating 'Database Editor' object failed"
	say "Exiting..."
	Exit
END; Else
	say "	Program Object for 'Database Editor' was created"

if (\ SysCreateObject('WPProgram',,
	'Database View',,
	'<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME='drive':\usr\bin\PM\DBView.exe;',
		'OBJECTID=<OBJC_VISDEV_DBV_PROGRAM_OBJECT>;',
		';ASSOCFILTER=*.dbf',,
	'replace')) THEN DO
	say "	Creating 'Database View' object failed"
	say "Exiting..."
	Exit
END; Else
	say "	Program Object for 'Database View' was created"

if (\ SysCreateObject('WPProgram',,
	'Console','<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME='drive':\usr\bin\PM\Console.exe;',
		'OBJECTID=<OBJC_VISDEV_CONSOLE_PROGRAM_OBJECT>;',,
	'replace')) THEN DO
	say "	Creating 'Console' object failed"
	say "Exiting..."
	Exit
END; Else
	say "	Program Object for 'Console' was created"

if (\ SysCopyObject(drive':\usr\lib\templates\Objc_Prj',,
	'<OBJC_VISDEV_FOLDER>')) THEN DO
	Say "	Creating Project template object failed"
	Say "Exiting..."
	Exit
END; Else
	Say "	Project template 'Objc_Project' was created"

if (\ SysCreateObject('WPProgram',,
	'Tutorial','<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME=view.exe;',
		';ICONFILE='drive':\usr\lib\icons\book.ico;',
		';PARAMETERS='drive':\usr\lib\book\Tutorial.inf',,
	'replace')) THEN DO
	Say "	Creating 'Tutorial' object failed"
	Say "Exiting..."
	Exit
END; Else
	Say "	Documentation object 'Tutorial' was created"

if (\ SysCreateObject('WPProgram',,
	'Reference','<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME=view.exe;',
		';ICONFILE='drive':\usr\lib\icons\book.ico;',
		';PARAMETERS='drive':\usr\lib\book\Referenc.inf',,
	'replace')) THEN DO
	Say "	Creating 'Reference' object failed"
	Say "Exiting..."
	Exit
END; Else
	Say "	Documentation object 'Reference' was created"

if (\ SysCreateObject('WPProgram',,
	'Tools','<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME=view.exe;',
		';ICONFILE='drive':\usr\lib\icons\book.ico;',
		';PARAMETERS='drive':\usr\lib\book\Tools.inf',,
	'replace')) THEN DO
	Say "	Creating 'Tools' object failed"
	Say "Exiting..."
	Exit
END; Else
	Say "	Documentation object 'Tools' was created"

if (\ SysCreateObject('WPProgram',,
	'Installation','<OBJC_VISDEV_FOLDER>',,
	'MINIMIZED=NO;',
		';PROGTYPE=PM;',
		';EXENAME=view.exe;',
		';ICONFILE='drive':\usr\lib\icons\book.ico;',
		';PARAMETERS='drive':\usr\lib\book\Install.inf',,
	'replace')) THEN DO
	Say "	Creating 'Installation' object failed"
	Say "Exiting..."
	Exit
END; Else
	Say "	Documentation object 'Installation' was created"

say ''
say 'A new folder "Visual Development" was created on your desktop.'
say 'The program objects for the development tools can be found there!'
Say ''
Say 'To complete installation, edit config.sys and add'
Say '"'drive':/usr/include" to the environment variables'
Say '"C_INCLUDE_PATH", "CPLUS_INCLUDE_PATH" and "OBJC_INCLUDE_PATH". Further'
Say 'add "'drive':/usr/lib" to the variable "LIBRARY_PATH". Always add the'
Say 'new paths at the beginning!'
Exit
