/* nm.h */

#include <sys/reg.h>

#define KERNEL_U_ADDR 0xe0000000

#undef FLOAT_INFO

#define REGISTER_U_ADDR(addr, blockend, regno) \
	(addr) = i386_register_u_addr ((blockend),(regno));

extern int
i386_register_u_addr PARAMS ((int, int));

#define PTRACE_ARG3_TYPE int
#define CHILD_WAIT
#define CHILD_THREAD_ALIVE

#define ATTACH_DETACH

#include "target.h"

extern int child_wait PARAMS ((int, struct target_waitstatus *));
extern int child_thread_alive (int);

#undef target_pid_to_str
#define target_pid_to_str(PID) emx_pid_to_str (PID)
