#define INCL_WIN
#define INCL_GPI
#include <OS2.H>
#include <stdlib.H>
#include <string.H>
#include "Buttons.H"

#define HAVECAPTURE 1
#define HAVEFOCUS   2
#define INSIDERECT  4
#define SPACEDOWN   8

typedef struct {
  PSZ       pszText;
  BYTE      Flags;
  HPOINTER  Bitmap;
} GBTN;

typedef GBTN *PGBTN;

MRESULT EXPENTRY ButtonClassProc(HWND, ULONG, MPARAM, MPARAM);

BOOL EXPENTRY RegisterShadedButtonClass() {
  return WinRegisterClass ((HAB) 0, SHADEDBTNCLASS, ButtonClassProc, CS_SIZEREDRAW, sizeof (PGBTN));
}

MRESULT EXPENTRY ButtonClassProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2) {
  POINTL        ptl;
  GBTN          *pGradBtn;
  WNDPARAMS     *pwprm;
  RECTL         rcl;

  pGradBtn = WinQueryWindowPtr (hwnd, 0);

  switch(msg) {
  case WM_CREATE: {
      CREATESTRUCT  *pcrst;
      pGradBtn = malloc (sizeof (GBTN));
      pGradBtn->Flags = 0;
      pcrst = (PCREATESTRUCT) PVOIDFROMMP(mp2);
      pGradBtn->pszText = malloc(1+strlen(pcrst->pszText));
      strcpy(pGradBtn->pszText, pcrst->pszText);
                        if (WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_GRAPHIC)
                                pGradBtn->Bitmap = WinLoadPointer(HWND_DESKTOP, NULL, atoi(pGradBtn->pszText));
    }

    WinSetWindowPtr(hwnd, 0, pGradBtn);
    return 0;
  case WM_SETWINDOWPARAMS:
    pwprm = (PWNDPARAMS) PVOIDFROMMP (mp1);
    if(pwprm->fsStatus & WPM_TEXT) {
      free(pGradBtn->pszText);
      pGradBtn->pszText = malloc(1+pwprm->cchText);
      strcpy(pGradBtn->pszText, pwprm->pszText);
    }
    return MRFROMSHORT(1);
  case WM_QUERYWINDOWPARAMS:
    pwprm = (PWNDPARAMS) PVOIDFROMMP (mp1);
    if(pwprm->fsStatus & WPM_CCHTEXT)
      pwprm->cchText = strlen (pGradBtn->pszText);
    if(pwprm->fsStatus & WPM_TEXT)
      strcpy (pwprm->pszText, pGradBtn->pszText);
    if(pwprm->fsStatus & WPM_CBPRESPARAMS)
      pwprm->cbPresParams = 0;
    if(pwprm->fsStatus & WPM_PRESPARAMS)
      pwprm->pPresParams = NULL;
    if(pwprm->fsStatus & WPM_CBCTLDATA)
      pwprm->cbCtlData = 0;
    if(pwprm->fsStatus & WPM_CTLDATA)
      pwprm->pCtlData = 0;
    return MRFROMSHORT (1);
  case WM_BUTTON1DOWN:
    if(WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_NOPUSH)
      break;
    WinSetFocus(HWND_DESKTOP, hwnd);
    WinSetCapture(HWND_DESKTOP, hwnd);
    pGradBtn->Flags |= HAVECAPTURE | INSIDERECT;
    WinInvalidateRect(hwnd, NULL, FALSE);
    return 0;
  case WM_MOUSEMOVE: {
      BOOL fTestInsideRect;
      if((pGradBtn->Flags & HAVECAPTURE) == 0)
        break;
      WinQueryWindowRect(hwnd, &rcl);
      ptl.x = MOUSEMSG(&msg)->x;
      ptl.y = MOUSEMSG(&msg)->y;
      fTestInsideRect = WinPtInRect (WinQueryAnchorBlock(hwnd), &rcl, &ptl);
      if(((pGradBtn->Flags & INSIDERECT) != 0) != fTestInsideRect) {
        pGradBtn->Flags ^= INSIDERECT;
        WinInvalidateRect(hwnd, NULL, FALSE);
      }
    }
    break;
  case WM_BUTTON1UP:
    if ((pGradBtn->Flags & HAVECAPTURE == 0) || !WinIsWindowEnabled(hwnd))
      break;
    WinSetCapture(HWND_DESKTOP, NULLHANDLE);
    pGradBtn->Flags &= !(HAVECAPTURE | INSIDERECT);
    WinQueryWindowRect(hwnd, &rcl);
    ptl.x = MOUSEMSG(&msg)->x;
    ptl.y = MOUSEMSG(&msg)->y;
    if(WinPtInRect(WinQueryAnchorBlock(hwnd), &rcl, &ptl))
      WinPostMsg(WinQueryWindow(hwnd, QW_OWNER), WM_COMMAND,
          MPFROMSHORT(WinQueryWindowUShort(hwnd, QWS_ID)),
          MPFROM2SHORT(CMDSRC_PUSHBUTTON, TRUE));
    WinInvalidateRect(hwnd, NULL, FALSE);
    return 0;
  case WM_ENABLE:
    WinInvalidateRect(hwnd, NULL, FALSE);
    return 0;
  case WM_SETFOCUS:
    pGradBtn->Flags |= SHORT1FROMMP(mp2) & HAVEFOCUS;
    WinInvalidateRect(hwnd, NULL, FALSE);
    return 0;
  case WM_CHAR:
    if(!(CHARMSG(&msg)->fs & KC_VIRTUALKEY) ||
         CHARMSG(&msg)->vkey != VK_SPACE    ||
         CHARMSG(&msg)->fs & KC_PREVDOWN    ||
                                 !WinIsWindowEnabled(hwnd))
      break;
    if(!(CHARMSG(&msg)->fs & KC_KEYUP))
      pGradBtn->Flags |= SPACEDOWN;
    else {
      pGradBtn->Flags &= !SPACEDOWN;
      WinPostMsg(WinQueryWindow(hwnd, QW_OWNER), WM_COMMAND,
          MPFROMSHORT(WinQueryWindowUShort(hwnd, QWS_ID)),
          MPFROM2SHORT(CMDSRC_PUSHBUTTON, FALSE));
    }
    WinInvalidateRect(hwnd, NULL, FALSE);
    return 0;
  case WM_PAINT: {
      HPS hps;
                        long height;
                        ULONG colour;
                        POINTL aptl[TXTBOX_COUNT];
// Initialize
                        WinQueryWindowRect(hwnd, &rcl);
                        height = rcl.yTop;
      hps = WinBeginPaint(hwnd, NULLHANDLE, NULL);
                        WinFillRect(hps, &rcl, CLR_PALEGRAY);
                        GpiCreateLogColorTable(hps, LCOL_RESET, LCOLF_RGB, 0L, 0L, NULL);
// ***Add clipping areas for rounded styles
// Draw gradient pattern
                        for(rcl.yTop = rcl.yBottom = 1; rcl.yTop < height; rcl.yTop++, rcl.yBottom++) {
        if (pGradBtn->Flags & (INSIDERECT | SPACEDOWN))
                colour = 138 + (76 * rcl.yBottom / height);
        else
                colour = 152 + (89 * rcl.yBottom / height);
        GpiSetColor(hps, colour << 16 | colour << 8 | colour);
        GpiMove(hps, (PPOINTL) &rcl.xLeft);
                                GpiLine(hps, (PPOINTL) &rcl.xRight);
                        }
// Draw border
                        rcl.yTop--;
                        rcl.xRight--;
                        rcl.yBottom = 0;
                        GpiMove(hps, (PPOINTL) &rcl.xLeft);
                        ptl.y = rcl.yBottom;
                        ptl.x = rcl.xRight;
                        GpiSetColor(hps, 0x00888888);
                        GpiLine(hps, &ptl);
                        if (WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_NORIGHTLINE)
                                GpiMove(hps, (PPOINTL) &rcl.xRight);
                        else
                                GpiLine(hps, (PPOINTL) &rcl.xRight);
                        GpiSetColor(hps, (pGradBtn->Flags & (INSIDERECT | SPACEDOWN) ? 0x00888888 : 0x00FFFFFF));
                        ptl.y = rcl.yTop;
                        ptl.x = rcl.xLeft;
                        GpiLine(hps, &ptl);
                        rcl.yBottom = 1;
                        if (!((WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_NOLEFTLINE) != FALSE))
                                GpiLine(hps, (PPOINTL) &rcl.xLeft);
                        rcl.yBottom = 0;
// ***Add rounded sides
// Draw text
                        GpiCreateLogColorTable(hps, LCOL_RESET, LCOLF_DEFAULT, 0L, 0L, NULL);
        ptl.x = rcl.xRight >> 1;
                        ptl.y = rcl.yTop >> 1;
                        if (WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_RIGHTROUND)
                        ptl.x -= rcl.yTop >> 1;
                        if (WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_LEFTROUND)
                                ptl.x += rcl.yTop >> 1;
                        if (pGradBtn->Flags & (INSIDERECT | SPACEDOWN)) {
                        ptl.x++;
                                ptl.y--;
                        }
                        if (WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_GRAPHIC) {
                                LONG PointerWidth, PointerHeight;
                                PointerWidth = WinQuerySysValue(HWND_DESKTOP, SV_CXPOINTER);
                                PointerHeight = WinQuerySysValue(HWND_DESKTOP, SV_CYPOINTER);
                                ptl.x -= PointerWidth >> 1;
                                ptl.y -= PointerWidth >> 1;
                                WinDrawPointer(hps, ptl.x, ptl.y, pGradBtn->Bitmap, WinIsWindowEnabled(hwnd) ? DP_NORMAL : DP_HALFTONED);
        } else {
                                GpiQueryTextBox(hps, strlen(pGradBtn->pszText), pGradBtn->pszText, TXTBOX_COUNT, aptl);
                                ptl.x -= aptl[TXTBOX_CONCAT].x >> 1;
                                ptl.y -= (aptl[TXTBOX_TOPLEFT].y + aptl[TXTBOX_BOTTOMLEFT].y) >> 1;
                                GpiSetColor(hps, (WinIsWindowEnabled(hwnd) ? CLR_BLACK : CLR_DARKGRAY));
                                GpiCharStringAt (hps, &ptl, strlen(pGradBtn->pszText), pGradBtn->pszText);
                        }
      WinEndPaint(hps);
      return 0;
    }
  case WM_DESTROY:
                if (WinQueryWindowULong(hwnd, QWL_STYLE) & GBT_GRAPHIC)
                        WinDestroyPointer(pGradBtn->Bitmap);
    free(pGradBtn->pszText);
    free(pGradBtn);
    return 0;
  }
  return WinDefWindowProc(hwnd, msg, mp1, mp2);
}
