/* video.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/video.h>

extern char *_v_mem;            /* Used for testing */

static void prt (const char *s)
{
  while (*s != 0)
    {
      v_putc (*s);
      ++s;
    }
}


int main (int argc, char *argv[])
{
  int width, height;
  int x, y;
  int start, end;
  int no_mem_flag;

  no_mem_flag = 0;
  if (argc == 2 && strcmp (argv[1], "-n") == 0)
    no_mem_flag = 1;

  if (!v_init ())
    {
      fprintf (stderr, "v_init() failed.\n");
      return 1;
    }

  if (no_mem_flag)
    _v_mem = NULL;

  v_dimen (&width, &height);
  v_getxy (&x, &y);
  v_getctype (&start, &end);
  printf ("<- (%d,%d)\n", x, y);
  printf ("Width=%d, height=%d\n", width, height);
  printf ("Cursor: start=%d, end=%d\n", start, end);
  v_gotoxy (10, 5);
  printf ("<- (10,5)\n");
  v_ctype (0, end);
  v_gotoxy (0, height-2);
  prt ("Hello 1\nHello 2\nHello 3");
  v_printf (" -- hello, this is %s!", "printf");
  return 0;
}
