/* spawn1.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <process.h>

int main (int argc, char *argv[])
{
  int i, rc;
  char *p;
  char *env[2] = {"spawn1child=1", NULL};

  if (getenv ("spawn1child") != NULL)
    {
      if (argc != 2 || strcmp (argv[0], "spawn1.exe") != 0
          || strcmp (argv[1], "-child") != 0)
        {
          fputs ("\nCommand line of child process is corrupt\n", stderr);
          exit (2);
        }
      exit (0);
    }

  if (argc != 1)
    {
      fputs ("Usage: spawn1\n", stderr);
      exit (1);
    }
  if (_osmode != OS2_MODE)
    {
      fputs ("This test program requires OS/2.", stderr);
      exit (0);                 /* Not a fatal error */
    }

  /* Fail earlier. */

  p = alloca (4);
  p = alloca ((((unsigned long)p & 0xffff) - 0x2800) & 0xffff);

  for (i = 1; i <= (1 << 14); ++i)
    {
      if ((i & 0xff) == 0)
        {
          putchar ('.');
          fflush (stdout);
        }
      rc = spawnle (P_WAIT, "spawn1.exe",
                    "spawn1.exe", "-child", (char *)0, env);
      if (rc < 0)
        {
          putchar ('\n'); fflush (stdout);
          perror ("spawnle()");
          exit (2);
        }
      if (rc > 0)
        {
          fputs ("Child process failed\n", stderr);
          exit (2);
        }

      /* Move the stack frame of emx.dll's __spawnve. */

      p = alloca (4);

      /* Attempt to move the buffer used by __spawnve of sys.lib. */

      p = malloc (0);
      if (p == NULL)
        p = malloc (4);
    }
  return 0;
}
