/* probe.c (emx+gcc) */

#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <stdlib.h>
#include <stdio.h>

#define TESTS   14

static VOID APIENTRY thread (ULONG arg);

int main (void)
{
  ULONG rc, i;
  TID tid;

  if (_osmode != OS2_MODE)
    {
      puts ("This program requires OS/2.");
      return 0;                 /* Don't abort regression test */
    }

  for (i = 0; i < TESTS; ++i)
    {
      printf ("Test %lu...\n", i);

      /* STACK_SPARSE is the point of creating another thread and
         doing the tests in that thread... */

      rc = DosCreateThread (&tid, thread, i, CREATE_READY | STACK_SPARSE,
                            512 * 1024);
      if (rc != 0)
        {
          fprintf (stderr, "DosCreateThread failed, rc=%lu\n", rc);
          return 2;
        }

      /* Wait for termination of the thread.  If the thread ends
         before DosWaitThread gets called, we'll get
         ERROR_INVALID_THREADID. */

      rc = DosWaitThread (&tid, DCWW_WAIT);
      if (rc != 0 && rc != ERROR_INVALID_THREADID)
        {
          fprintf (stderr, "DosWaitThread failed, rc=%lu\n", rc);
          return 2;
        }
    }
  
  return 0;
}


struct big
{
  char a[8190];
  char c1, c2;
};

static volatile char x;


static void test0 (void)
{
  char a[4096];

  a[0] = x;
}


static void test1 (void)
{
  char a[8192];

  a[0] = x;
}


static void test2 (void)
{
  char a[100000];

  a[0] = x;
}


static struct big test3b (void)
{
  struct big b;

  return b;
}


static char test3 (void)
{
  char a[4096];

  a[0] = x;
  return test3b().c1;
}


static void test4 (void)
{
  char *p;

  p = alloca (10000);
  *p = 0;
}


static void test5 (void)
{
  char *p;

  p = alloca (100000);
  *p = 0;
}


static void test6 (ULONG n)
{
  char *p;

  p = alloca (n);
  *p = 0;
}


static void test7 (int loops)
{
  char *p;

  while (loops-- > 0)
    {
      p = alloca (10000);
      *p = 0;
    }
}


static void test8 (int loops, ULONG n)
{
  char *p;

  while (loops-- > 0)
    {
      p = alloca (n);
      *p = 0;
    }
}


static VOID APIENTRY thread (ULONG arg)
{
  switch (arg)
    {
    case 0:
      test0 ();
      break;
    case 1:
      test1 ();
      break;
    case 2:
      test2 ();
      break;
    case 3:
      test3 ();
      break;
    case 4:
      test4 ();
      break;
    case 5:
      test5 ();
      break;
    case 6:
      test6 (0);
      break;
    case 7:
      test6 (4000);
      break;
    case 8:
      test6 (4096);
      break;
    case 9:
      test6 (4100);
      break;
    case 10:
      test6 (8192);
      break;
    case 11:
      test6 (16384);
      break;
    case 12:
      test7 (4);
      break;
    case 13:
      test8 (4, 8192);
      break;
    }
  DosExit (EXIT_THREAD, 0);
}
