/* inet.c (emx+gcc) */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main (int argc, char *argv[])
{
  char line[512], *p;
  unsigned long ip1, ip2;
  struct in_addr in;

  if (argc != 1)
    {
      fputs ("Usage: inet\n", stderr);
      return 1;
    }

  while (fgets (line, sizeof (line), stdin) != NULL)
    {
      if (line[0] == '#') continue;
      p = strchr (line, '\n');
      if (p != NULL) *p = 0;
      ip1 = inet_addr (line);
      ip2 = inet_network (line);
      in.s_addr = ip1;
      printf ("0x%.8lx 0x%.8lx %s\n", ip1, ip2, inet_ntoa (in));
    }
  return 0;
}
