/* strtod.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <errno.h>

static const char *errno_str (void)
{
  static char buf[40];

  switch (errno)
    {
    case 0:
      return "NOERROR";
    case ERANGE:
      return "ERANGE";
    case EDOM:
      return "EDOM";
    case EINVAL:
      return "EINVAL";
    default:
      sprintf (buf, "#%d", errno);
      return buf;
    }
}


int main (int argc, char *argv[])
{
  char buf[100], *p, type;
  const char *e;
  float f;
  double d;
  long double ld;

  type = 'd';
  if (argc == 2 && strcmp (argv[1], "-l") == 0)
    type = 'l';
  else if (argc == 2 && strcmp (argv[1], "-f") == 0)
    type = 'f';
  else if (argc != 1)
    {
      fputs ("Usage: strtod [-{lf}]\n", stderr);
      return 1;
    }
  while (fgets (buf, sizeof (buf), stdin) != NULL)
    {
      p = strchr (buf, '\n');
      if (p != NULL)
        *p = 0;
      errno = 0;
      if (type == 'l')
        {
#if defined (__EMX__)
          ld = strtold (buf, &p);
          e = errno_str ();
          printf ("%26.19Le %d %s\n", ld, (int)(p - buf), e);
#endif
        }
      else if (type == 'f')
        {
#if defined (__EMX__)
          f = strtof (buf, &p);
          e = errno_str ();
          printf ("%26.19e %d %s\n", f, (int)(p - buf), e);
#endif
        }
      else
        {
          d = strtod (buf, &p);
          e = errno_str ();
          printf ("%26.19e %d %s\n", d, (int)(p - buf), e);
        }
    }
  return 0;
}
