/* initt.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <stddef.h>
#include <umalloc.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <sys/smutex.h>
#include <sys/uflags.h>
#include <emx/umalloc.h>
#include <emx/thread.h>

/* This is the default tiled heap. */

Heap_t _um_tiled_heap = NULL;


/* This is an attempt at provoking a linker error if malloc() has been
   replaced and -ltmalloc has been forgotten.  By referencing the
   _emx_tmalloc_magic() function, we force in the module compiled from
   malloc.c.  That will hopefully conflict with the replacement
   malloc().  Note that the symbol must actually be used; we do this
   by calling the function. */

extern void _emx_tmalloc_magic (void);


void _um_init_default_tiled_heap (void)
{
  _UM_MT_DECL
  static _smutex lock;

  _smutex_request (&lock);

  /* Create the tiled heap if it hasn't been created by another thread
     between the check of _UM_DEFAULT_TILED_HEAP by our caller and
     obtaining the semaphore. */

  if (_UM_DEFAULT_TILED_HEAP == NULL)
    {
      if (_um_tiled_heap == NULL)
        {
          /* Use the regular heap also as tiled heap. */

          _emx_tmalloc_magic ();
          _um_init_default_regular_heap ();
          _um_tiled_heap = _um_regular_heap;
        }


      _UM_DEFAULT_TILED_HEAP = _um_tiled_heap;
    }

  _smutex_release (&lock);
}
