/* puts.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <emx/io.h>

int puts (const char *string)
{
  int result, len;
  void *tb;

  len = strlen (string);
  STREAM_LOCK (stdout);
  if (nbuf (stdout))
    _fbuf (stdout);
  _tmpbuf (stdout, tb);
  if (len == 0 || _fwrite_nolock (string, len, 1, stdout) == 1)
    result = _putc_inline ('\n', stdout);
  else
    result = EOF;
  if (_endbuf (stdout) != 0)
    result = EOF;
  STREAM_UNLOCK (stdout);
  return result;
}
