/* heapset.c (emx+gcc) -- Copyright (c) 1996 by Eberhard Mattes */

#include <stdlib.h>
#include <stddef.h>
#include <umalloc.h>
#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <emx/umalloc.h>
#include <emx/thread.h>

int _heapset (unsigned fill)
{
  _UM_MT_DECL
  int rc1, rc2;

  /* First fill the regular heap. */

  rc1 = _uheapset (_UM_DEFAULT_REGULAR_HEAP, fill);
  if (rc1 != _HEAPOK && rc1 != _HEAPEMPTY)
    return rc1;

  /* If there's no tiled heap or if it's identical to the regular
     heap, return the regular heap's status. */

  if (_UM_DEFAULT_REGULAR_HEAP == _UM_DEFAULT_TILED_HEAP
      || _UM_DEFAULT_TILED_HEAP == NULL)
    return rc1;

  /* Fill the tiled heap.  Do not return _HEAPEMPTY if any of the two
     heaps is non-empty. */

  rc2 = _uheapset (_UM_DEFAULT_TILED_HEAP, fill);
  if (rc2 == _HEAPEMPTY)
    return rc1;
  return rc2;
}
