/* _flush.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>
#include <emx/io.h>

int _flush (int c, FILE *stream)
{
  /* Don't flag an error attempting to write beyond the end of the
     string for snprintf() as we need the total number of characters
     printed. */

  if ((stream->_flags & _IOSPECIAL) && stream->_flush == NULL)
    return (unsigned char)c;

  /* Fail if the stream is not open or there is no function for
     flushing the buffer. */

  if (!(stream->_flags & _IOOPEN) || stream->_flush == NULL)
    {
      errno = EACCES;
      return EOF;
    }

  /* Fail if the stream is in read mode. */

  if (stream->_flags & _IOREAD)
    {
      stream->_flags |= _IOERR;
      errno = EACCES;
      return EOF;
    }

  /* Flush the buffer and put C into the buffer. */

  if (stream->_flush (stream, (unsigned char)c) != 0)
    return EOF;
  return (unsigned char)c;
}
