#include <stdio.h>
#include <stdlib.h>

// Ikkunanksittelyyn kytettvt vakiot tarvitsevat seuraavaa
// rivi, esim. CV_CXSCREEN
#define INCL_WIN

#include "window.h"

void main(int argc, char *argv[]) {
	HMQ 	hmq;
	QMSG 	qmsg;
	HWND 	hwndFrame,hwndDrawing;
	ULONG	flFrameFlags;

	char otsikko[]="Ikkuna auki";	  // ikkunan otsikko

// hab = anchor block handle. Hab on jokaisella sikeell, jolla
// on oma ikkuna.

	hab=WinInitialize(0);

// Luodaan viestijono juuri luodulle threadille. 0=default viestijonon
// pituus = 10 ksky.

	hmq=WinCreateMsgQueue(hab,0);

// Luodaan ikkunaluokka. Kolmas parametri on ikkuna-funktio, joka
// on client.c:ss.

	WinRegisterClass(hab,				// HAB
					otsikko,			// ikkunaluokan nimi
					(PFNWP)ClientWndProc,
					CS_SIZEREDRAW,		// tyyli
					(USHORT)0);			// ???

// tss muuttujassa mritelln ikkunan ulkonk yms.

	flFrameFlags =	FCF_TITLEBAR |		// otsikkopalkki
					FCF_SYSMENU | 		// systeemimenu
					FCF_TASKLIST |		// ohjelma on tasklistiss
					FCF_SIZEBORDER | 	// reunukset
					FCF_MINMAX | 		// minimointi&maximointi napit
					FCF_SHELLPOSITION;	// Systeemi mrittelee sij.
										// ja koon.
											
// luodaan ikkuna.
	hwndFrame = WinCreateStdWindow(
					HWND_DESKTOP,		// omistaja-ikkuna
					WS_VISIBLE,			// frame-windowsin tyyli
					&flFrameFlags,		// em. ulkonkmuuttuja
					otsikko,			// luokan nimi
					otsikko,			// otsikko
					0L,					// client-windowsin tyyli
					NULLHANDLE,			// DDL handle
					0,					// resurssi-id
					&hwndDrawing);		// client-window-handelin osoite

// Ikkunan subclassing. Subclassing on menetelm jolla ikkunaluokan
// kyttytymist voidaan muuttaa. Tss ohjelmassa subclassing 
// tarkkailee ikkunan kokoa, ja est sen liiallisen pienentmisen.
// Subclassing ei ole ikkunan aukaisemiseksi vlttmtn.

	pfnNormalFrameProc = WinSubclassWindow(
					hwndFrame,
					SubClassFrameProc);
	lWidth  = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN);
	lHeight	= WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
	pFrameInfo = calloc(1, sizeof(FRAMEINFO));
	WinSetWindowPtr(hwndFrame, QWL_USER, pFrameInfo);
	pFrameInfo->lWidth  = lWidth;
	pFrameInfo->lHeight = lHeight;
	pFrameInfo->pfnNormalFrameProc = pfnNormalFrameProc;

// Seuraava ksky ei liity en subclassingiin. Asetellaan ikkuna
// ruudulle. Ttkin ksky ilman tullaan hyvin toimeen.
	WinSetWindowPos (	
		hwndFrame,			// frame-ikkunan handle
		HWND_TOP,			// z-order
		10, 10, 400, 300,	// alakulma ja koko
		SWP_ACTIVATE | 		// tyyli: aktiivinen ikkuna
		SWP_SHOW |			// nyt ikkuna
		SWP_SIZE |			// kokoa voi muuttaa??
		SWP_MOVE);			// voi siirt??

// Viestilooppi. WinGetMsg vastaanottaa viestit ohjelman 
// viestijonolta. Looppi jatkuu, kunnes ohjelma lhett 
// WM_QUIT-viestin esim. valitsemalla sys-menusta quit.

	while(WinGetMsg(
			hab,			// input hab
			&qmsg,			// viestidata
			NULLHANDLE,		// viestifiltteri. Kaikki vaan lpi!
			0L,	
			0L))
// Kaksi viimeist parametria liittyy viestien suodattamiseen,
// (viestinumeroihin, joita ei vlitet ohjelmalle)

// WinDispatchMsg lhett vastaanotetun viestin ikkunafunktiolle
// (mriteltiin WinRegisterClass:n 3. parametrissa).  Ilman WinGetMsg
// ja WinDispatchMsg kskyj warp iloittaa, ettei ohjelma vastaa. 

		WinDispatchMsg(hab,&qmsg);

// Ohjelma lopetetaan

	WinDestroyWindow(hwndFrame);
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	return;
}
