#include <stdio.h>
#include <stdlib.h>

#define INCL_GPI
#define INCL_WIN

#include "window.h"

// Ikkunan subclassing
MRESULT EXPENTRY SubClassFrameProc(HWND hwndFrame, ULONG  ulMsg,  MPARAM
mpParm1, MPARAM mpParm2) {
   	PFRAMEINFO       pFrameInfo;
   	PFNWP            pfnNormalFrameProc;

	pFrameInfo = WinQueryWindowPtr(hwndFrame, QWL_USER);

   	pfnNormalFrameProc = pFrameInfo->pfnNormalFrameProc;

	switch (ulMsg)
   	{
      	case  WM_QUERYTRACKINFO : {
			PTRACKINFO       pTrackInfo;
            MRESULT          mrReply;

            mrReply = (*pfnNormalFrameProc)(hwndFrame,
                                            ulMsg,
                                            mpParm1,
                                            mpParm2);
            pTrackInfo = (PTRACKINFO)PVOIDFROMMP(mpParm2);
            pTrackInfo->ptlMinTrackSize.x = pFrameInfo->lWidth/2;
            pTrackInfo->ptlMinTrackSize.y = pFrameInfo->lHeight/2;

            return  mrReply;
		}
		
		case  WM_DESTROY : {
            if (pFrameInfo)
               free(pFrameInfo);
            break;
         }

      default  :
         break;

   }

	// palataan normaaliin frame-windowsin ksittelyyn
   return ((*pfnNormalFrameProc)(hwndFrame,
                                 ulMsg,
                                 mpParm1,
                                 mpParm2));

};

// Seuraava funktio vastaanottaa kaikki ikkunalle lhetetyt viestit.
// MRESULT on sen merkiksi, ett kyttjrjestelm kutsuu funktiota,
// eik ohjelma. Funktion parametrit ovat: client-windowsin handle,
// viesti, mp1 ja mp2 ovat viesti parametrej. Esim. kun hiirt
// liikutetaan, lhetetn viesti WM_MOUSEMOVE ja mp1:ss hiiren 
// koordinaatit. mp1 ja mp2 on 32-bittisi lukuja, joten usein
// yhdess parametriss vlitetn kaksi 16-bittist lukua.

MRESULT ClientWndProc(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2) {
// Tm ohjelma ei tee muuta kuin avaa ikkunan.  Siksi tm
// ikkunafunktio on hyvin yksinkertainen. Ikkunafuntiot ovat usein
// vain suuria switch-kyhelmi.

	switch(msg) {

// Viesti WM_ERASEBACKGROUND ksky kytetn ikkunan maalaamiseen
// systeemin oletusikkunan pohjavrill.  Jos tt viesti ei
// ksitell, j luotava ikkuna lpinkyvksi. Palauttamalla TRUE,
// kerrotaan warpille, ett ikkunaan haluttaisiin nyt vhn vri.

		case WM_ERASEBACKGROUND:
			return MRFROMSHORT(TRUE);
	}

// Annetaan warpin ksitell loput viestit.  Jos seuraavaa rivi ei
// ole, ollaan nalkissa.
	return(WinDefWindowProc(hwnd,msg,mp1,mp2));
}
