/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.BevelPanel;
import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetAware;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.StatusEvent;
import borland.jbcl.dataset.StatusListener;
import borland.jbcl.util.BlackBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class StatusBar
extends BevelPanel
implements NavigationListener,
StatusListener,
AccessListener,
DataSetAware,
BlackBox {
    protected DataSet dataSet;
    protected Label label = new Label();
    private boolean addNotifyCalled = false;

    public StatusBar() {
        this.setLayout(new BorderLayout());
        this.setMargins(new Insets(0, 2, 0, 2));
        this.add((Component)this.label, "Center");
    }

    public int getAlignment() {
        return this.label.getAlignment();
    }

    public void setAlignment(int n) {
        this.label.setAlignment(n);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeStatusListener(this);
        }
        this.openDataSet(dataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addStatusListener(this);
        }
    }

    private void openDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException dataSetException) {
                DataSetException.handleException(this.dataSet, this, dataSetException);
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.updateValue();
        }
    }

    public void statusMessage(StatusEvent statusEvent) {
        this.setText(statusEvent.getMessage());
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                this.updateValue();
                break;
            }
            case 2: {
                this.setText("");
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateValue();
    }

    protected void updateValue() {
        if (this.dataSet != null && this.dataSet.isOpen()) {
            try {
                if (this.dataSet.getRowCount() > 0) {
                    this.setText(Res.format(19, new Long(this.dataSet.getRow() + 1), new Long(this.dataSet.getRowCount())));
                } else {
                    this.setText(Res.getString(20));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.label.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.label.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.label.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.label.removeMouseMotionListener(mouseMotionListener);
    }

    public String toString() {
        return this.getText();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < 200) {
            dimension.width = 200;
        }
        return dimension;
    }
}

