/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.wizards;

import java.io.*;
import java.awt.*;
import java.util.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import com.sun.java.swing.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
/** This class represents the panel, containing the package name, the class name
    and the path to the package in both wozards.
*/
class ClassPathAndNamePanel extends BPanel {
  private JTextField Package  = new JTextField();
  private JTextField Class    = new JTextField();
  private JComboBox Path;

  private BPanel PackagePanel;
  private BPanel ClassPanel;
  private BPanel PathPanel;

  private String [] parsePackName (String PackName) {
    return Misc.parsePath (PackName, '.');
  }

  public String getFileName () {
    String FileName = new File (getPath()).getAbsolutePath();
    String Package  = getPackage().replace('.', Globals.FileSeparatorChar);
    FileName += Globals.FileSeparatorChar + Package + Globals.FileSeparatorChar + getClassName() + Globals.JavaFileExt;
    return FileName;
  }

  private String [] getSourcePaths () {
    PathsOptions PathsOpts = (PathsOptions) Globals.Options.getOptions (PathsOptions.PathsOptionsName);
    String [] Paths = PathsOpts.getSourcePath();
    Vector Dirs = new Vector();
    Dirs.addElement (Globals.getProjectPath());
    for (int i = 0; i < Paths.length; i++) {
      File CurrentElement = new File (Paths[i]);
      if (!CurrentElement.isFile())
        Dirs.addElement (Paths[i]);
    }
    String [] Ret = new String [Dirs.size()];
    Dirs.copyInto (Ret);
    return Ret;
  }

  public ClassPathAndNamePanel (String What){
    PackagePanel = new BPanel(What + " Package");
    ClassPanel   = new BPanel(What + " Class");
    PathPanel    = new BPanel(What + " Source Path");

    String [] SourcePaths = getSourcePaths ();
    Path = new JComboBox (SourcePaths);

    ClassPanel.setLayout(new BorderLayout());
    ClassPanel.add (Class, BorderLayout.CENTER);

    PathPanel.setLayout(new BorderLayout());
    PathPanel.add (Path, BorderLayout.CENTER);

    PackagePanel.setLayout(new BorderLayout());
    PackagePanel.add (Package, BorderLayout.CENTER);

    setLayout (new GridLayout (3, 1, 5, 5));
    add (PathPanel);
    add (PackagePanel);
    add (ClassPanel);
  }

  /** Checks the validity of the input data:
      If the package name consists of dot separated valid java identifiers.
      If the class name is a valid java identifier.
      If a path to the package is selected.
  */
  public boolean checkValidity () {
    if (!Misc.isValidID(Class.getText())) {
      Misc.messageBox (new String [] {"OK"}, new String [] {"Enter a valid identifier for class name."}, 0);
      return false;
    }

    if (!isValidPackID(Package.getText())) {
      Misc.messageBox (new String [] {"OK"}, new String [] {"Enter a valid identifier for package name."}, 0);
      return false;
    }

    if (Path.getSelectedIndex() == -1) {
      Misc.messageBox (new String [] {"OK"}, new String [] {"Choose a source path.", "(or enter a directory in \"Source Path\" project property)"}, 0);
      return false;
    }
    return true;
  }

  private boolean isValidPackID (String PackName) {
    String [] Dirs = parsePackName(PackName);
    if ((Dirs == null) || (Dirs.length==0))
      return false;
    for (int i = 0; i < Dirs.length; i++)
      if (!Misc.isValidID (Dirs[i]))
        return false;
    String TruePackName = "";
    for (int i = 0; i < Dirs.length; i++) {
      TruePackName += Dirs[i];
      if (i < Dirs.length - 1)
        TruePackName += ".";
    }
    Package.setText (TruePackName);
    return true;
  }

  public String getPackage () {
    return Package.getText();
  }
  public String getPath () {
    return Path.getSelectedItem().toString();
  }
  public String getClassName () {
    return Class.getText();
  }
}
