/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.paths;

import java.io.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class DistinctPathItem {
  public static final int FROM_CLASS_PATH          = 0;
  public static final int FROM_SOURCE_PATH         = 1;
  public static final int FROM_DOC_PATH            = 2;
  public static final int FROM_JAVADOC_OUT_PATH    = 3;
  public static final int FROM_CLASS_OUT_PATH      = 4;
  public static final int FROM_PIZZASOURCEOUT_PATH = 5;
  public static final int NOT_FROM_SYSTEM_PATHS    = 6;

  private int    PartOf;
  private File   Directory;

  public DistinctPathItem (String TheDir, int PartOfWhat) {
    PartOf    = PartOfWhat;
    Directory = new File (TheDir);
  }

  public int partOfWhat () {
    return PartOf;
  }

  public File getDirectory () {
    return Directory;
  }

  public String getType () {
    switch (PartOf) {
      case FROM_CLASS_PATH:
        return "Class Path";
      case FROM_SOURCE_PATH:
        return "Source Path";
      case FROM_DOC_PATH:
        return "Doc Path";
      case FROM_JAVADOC_OUT_PATH:
        return "JavaDOC Output Path";
      case FROM_CLASS_OUT_PATH:
        return "Class Files Output Path";
      case FROM_PIZZASOURCEOUT_PATH:
        return "Pizza Source Out Path";
      case NOT_FROM_SYSTEM_PATHS:
        return "Not System Path";
    }
    return "Not Qualified Path";
  }
}


