/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;

/** <code>PacketItemI</code> is for organizing hirerachically packets.
  * every element in this hierarchy (item) have to implement this interface
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/
public interface PacketItemI extends RootPathI {
  public static  final  int cpikUnknown          = 0;
  public static  final  int cpikDirectory        = cpikUnknown    + 1;
  public static  final  int cpikPacket           = cpikDirectory  + 1;
  public static  final  int cpikSource           = cpikPacket     + 1;
  public static  final  int cpikClass            = cpikSource     + 1;
  public static  final  int cpikHtml             = cpikClass      + 1;
  public static  final  int cpikAny              = cpikHtml       + 1;

  /** Returns full dos path to the File or Directory including it's name .
    * If it is in a .Zip or .Jar file, returns Path to the Archive + path in the archive.
    * Example : Returns 'c:\FBProject\FBuilder\fb\system\classes\Strings.java' */
  public  String getFullDosPath();

  /** Returns relative to the RootItem path to the File or Directory including it's name .
    * Example : Returns 'fb\system\classes\Strings.java' */
  public  String getRelativeDosPath();

  /** calls getRelativeDosPath() */
  public  String getPath();

  /** Example : Returns 'org.freebuilder.system.classes.Strings.java'
    * if this is a root item this method returns an empty string  */
  public  String getDotName();

  /** Example : Returns 'Strings.java' */
  public  String getFileName();

  /** Compares ADotName with the string returned by getDotName() */
  public  boolean MatchDotName(String ADotName);

  /** Compares with FullDosPath */
  public  boolean MatchPath    (String APath);

  /** Compares with FullDosPath */
  public  boolean MatchFileName(String AFileName);

  /** looks for this packet only in current (this) PacketItemI. (Not recursivelly) */
  public PacketItemI findPacketItem(String AFullDosName); 
  /** looks for this packet recursivelly */
  public PacketItemI findPacketItemR(String AFullDosName);

  /** retunrs IndexOf(this) in parent item */
  public  int     getIndex();
  
  /** returns true if it is in a .jar or .zip file */
  public  boolean isStable(); // true - if Is In Library

  /** returns one of the cpik ... constants. The item can be :
    * Directory        if (of all the subitems) there is not even one which is Java or Class or Packet or Project
    * Packet           if (of all the subitems) there is at least one which is Java, Class or Packet
    * PacketsHierarchy when compiling, browse .. this packet and all the packets in it recursively.
    * Java             if this item ends with .java
    * Class            if this item ends with .class
    * Html             if this item ends with .htm, or .html
    * Any              if this item does not match even one of the above rules.
  */
  public  int         getPacketItemKind();
  /** returns true if the file have been changed */
  public  boolean     isChanged();
  /** update it's values by looking at the disk or in some jar, or zip.
    * for example it it is a packet or directory can scan again for files in it. */
  public  void        Refresh();

  /* The next methods functions will be used for organizing a tree hierarchy */
  /* ----------------------------------------------------------------------- */

  /** returns Parent Item. Parent item is the one to which this belongs
    * Example : if this item is 'java.lang.String', getParentItem() will return 'java.lang' */
  public  PacketItemI getParentItem();

  /** returns the Root item of the tree hierarchy. The Root item can be of type Packet, PacketHierarchy or Project, or Directory */
  public  PacketItemI getRootItem();

  /** set Parent item for this item, or clear it */
  public  void        setParentItem(PacketItemI AParentItem);
  /** set Root item for this item, or clear it */
  public  void        setRootItem  (PacketItemI ARootItem);
  /** get number subitems in this item */
  public  int         getPacketItemsCount();
  /** get Packet Item by It's index in Parent's item */
  public  PacketItemI getPacketItemAt(int AIndex);
  /** get Packet Item by It's index in Parent's item */
  public  PacketItemI getPacketItemByFileName(String AFileName);
  /** get Packet Item by It's dot name */
  public  PacketItemI getPacketItemByDotName(String ADotName);
  /** set Packet Item to some position in Parent's item */
  public  void        setPacketItemAt(int AIndex, PacketItemI APacketItem);
  /** Add a Packet Item as a subitem of Parent's item */
  public  int         addPacketItem(PacketItemI APacketItem);
  /** finds some Packet item in this one. if not found returns -1 */
  public  int         IndexOfPacketItem(PacketItemI APacketItem);
  /* ----------------------------------------------------------------------- */

  public void TestPrint();
  public void ShortTestPrint();
}

