/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.Globals;
import java.io.File;

/** <code>PDirectoryEntry</code> is for organizing hirerachically packets and projects
  * every element in this hierarchy (item) have to implement this interface
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class PDirectoryEntry extends PacketsContainer  {
  private File        FFile                = null;
  private long        LastFileModification = 0;

  public PDirectoryEntry(File AFile, PacketItemI AParentItem, PacketItemI ARootItem) {
    super(AParentItem, ARootItem,"");
    FFile      = AFile; if (FFile == null) return;
    FileName = FFile.getName();
    if (ARootItem == null)
      FileName = FFile.getAbsolutePath();

    csetFileName(FileName);
    LastFileModification = 0;
  }

  public  boolean isStable() {
    return false;
  }

  public  boolean isChanged() {
    if (ItemKind == PacketItemI.cpikUnknown) return true;
    /*
    if (FFile == null)    return false;
    if (! FFile.exists()) return false;

    long NewModification = FFile.lastModified();
    return LastFileModification != NewModification;
    */
    return false;
  }

  /** adds the file first */
  private int addFileItem(PacketItemI APacketItem) {
    if (APacketItem == null) return -1;
    String AFileName = APacketItem.getFileName();
    Insert(0, AFileName, APacketItem);
    return 0;
  }

  protected PacketItemI CreateDirEntry(File AFile, PacketItemI AParentItem, PacketItemI ARootItem) {
    PacketItemI Result = new PDirectoryEntry(AFile, AParentItem, ARootItem);
    return Result;
  }

  public PacketItemI AddEntry(String AFileName, PacketItemI ARootItem) {
    PacketItemI Result = null;
    File        AFile  = null;

    if (AFileName == null) return null;
    if (AFileName.length() == 0) return null;

    AFileName = Globals.AddFName2Path(getFullDosPath(), AFileName);
    try {
      AFile = new File(AFileName);
    }
    catch(NullPointerException e) { return null; }

    if (AFile.isDirectory()) {
      Result = CreateDirEntry(AFile, this, ARootItem);
      addPacketItem(Result);
    }
    else {
      Result = new PFileEntry(AFile, this, ARootItem);
      addFileItem(Result);
    }
    return Result;
  }

  public void Refresh() {
    if (! isChanged()) return;
    // LastFileModification = FFile.lastModified();
    getPacketItemKind(); // in super -> if ((ItemKind == PacketItemI.cpikUnknown) || (isChanged())) setPacketItemKind();
  } // Have to override

  protected int justGetCount() {
    return super.getCount();
  }

  public int getPacketItemsCount() {
    String DirName = getFullDosPath();
    Refresh();
    return justGetCount();
  }

  public  void    RefreshItems() {
    boolean done         = false;
    boolean isDirChanged = false;
    boolean LFileExist   = FFile != null;
    String  [] Files     = null;
    String     CrntFName;
    StringList StrL;
    int To, Cntr, Index;
    PacketItemI   CrntItem;
    PacketItemI   ARootItem = getRootItem();

    BeginUpdate();
    try {
      // if there is not such a directory, and number items != 0 then isDirChanged = true;
      if (LFileExist)
        LFileExist = FFile.exists();

      if (LFileExist && (justGetCount() != 0)) {
        Clear(); isDirChanged = true; return;
      }
      // ----------------------------------------------------------------------------------

      Files = FFile.list();     // Save all the items in current directory in a StringList
      StrL  = new StringList(200,50);
      for (Cntr = 0; Cntr < Files.length; Cntr++)
        StrL.Add(Files[Cntr]);

      // Let's remove the old items and leave only the new items in StrL
      Cntr = 0;
      while (Cntr < justGetCount()) {
        try {
          CrntFName = getString(Cntr);
          Index     = StrL.IndexOf(CrntFName);
          if (Index < 0) { // it is an old file
            Delete(Index); isDirChanged = true;
          }
          else {
            StrL.Delete(Index);
          }
        } catch(ArrayIndexOutOfBoundsException e) {}
        Cntr ++;
      }

      // Let's add the new directory items
      To = StrL.getCount();
      try {
        for (Cntr = 0; Cntr < To; Cntr++) {
          CrntFName = StrL.getString(Cntr);

          if (ARootItem == null) AddEntry(CrntFName, this);
          else                   AddEntry(CrntFName, ARootItem);
        }
      } catch(ArrayIndexOutOfBoundsException e) {}
    }
    finally {
      EndUpdate();
    }
    LastFileModification = FFile.lastModified();
  }

  protected int setPacketItemKind() {
    PacketItemI PItem = null;
    int Cntr = 0, To = 0;
    int CrntItemKind = PacketItemI.cpikUnknown;

    RefreshItems();
    To = justGetCount();

    for (Cntr = 0; Cntr < To; Cntr++) {
      PItem = getPacketItemAt(Cntr);
      if (PItem == null) continue;
      CrntItemKind = PItem.getPacketItemKind();
      if ((CrntItemKind == PacketItemI.cpikPacket) || (CrntItemKind == PacketItemI.cpikSource) ||
          (CrntItemKind == PacketItemI.cpikClass)) {
        ItemKind = PacketItemI.cpikPacket;
        return ItemKind;
      }
    }

    ItemKind = PacketItemI.cpikDirectory;
    return ItemKind;
  }



}
