/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.Globals;
import java.io.File;

/** <code>PDirectoryEntry</code> is for organizing hirerachically packets and projects
  * every element in this hierarchy (item) have to implement this interface
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12-12-97
*/

public class PCreateEntry {
  public static PacketItemI CreateEntry(String FileName) {
    PacketItemI     Result = null;
    File            AFile  = null;
    String          LFileName;

    if (FileName == null) return null;
    if (FileName.length() == 0) return null;

    try {AFile = new File(FileName); }
    catch(NullPointerException e) { return null; }

    if (AFile.isDirectory()) {
      Result = new PDirectoryEntry(AFile, null, null);
      // Result.Refresh();
      return Result;
    }

    LFileName = FileName.toLowerCase();
    if (LFileName.endsWith(".zip") || LFileName.endsWith(".jar")) {
      Result = new PZipDirectoryEntry (AFile.getAbsolutePath(), null, null);
      // Result.Refresh();
      return Result;
    }

    Result = new PFileEntry(AFile,null,null);
    // Result.Refresh();

    // Result.ShortTestPrint();
    // Result.TestPrint();
    return Result;
  }

  public static PacketItemI CreateDirEntry(String DirName) {
    PacketItemI     Result = null;
    File            AFile  = null;

    if (DirName == null) return null;
    if (DirName.length() == 0) return null;

    try {AFile = new File(DirName); }
    catch(NullPointerException e) { return null; }

    if (AFile.isDirectory()) {
      Result = new PDirectory(AFile, null, null);
      // Result.Refresh();
      return Result;
    }
    return null;
  }


}
