/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.debug;

/** Class <code>AssertException</code> will be used from org.freebuilder.system.Debug.java.
  * When Debug.Assert method is called with no exception, AssertException is thrown.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

class AssertException extends Exception {
    /** Constructs an <code>AssertException</code> with no specified detail message.
     * @since   JDK1.0 */
    public AssertException() {
	this("Assert Exception");
    }

    /** Constructs an <code>AssertException</code> with the specified detail message.
     * @param   s   the detail message.
     * @since   JDK1.0 */
    public AssertException(String s) {
	super(s);
    }
}
