/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options.opened;

import java.lang.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;

/** This class is dedicated for supporting 'The last Opened Projects' feature
  * It members also if the last used file was opened.
  * You shold use only OnOpenFile & OnCloseFile methods from this class
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class StrLLastProjects extends StrItems {
  protected boolean FIsOpened;

  public StrLLastProjects(String AOptionsName) {
    super(AOptionsName);
    FIsOpened = false;
  }

  public synchronized Object clone() { // Will clone only the strings !!!!
    return super.clone();
  }

  /** Clears the collection */
  public void setDefaults() {
    super.setDefaults();
    FIsOpened = false;
  }

  /** Compares the strings of both collections */
  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    StrLLastProjects Other = (StrLLastProjects)TheOtherOne;
    boolean Result = super.IsDifferent(Other); if (Result) return true;
    Result = FIsOpened != Other.FIsOpened;
    return  Result;
  }

  public int OnOpenFile(final String S) {
    FIsOpened = true;
    return super.OnOpenFile(S);
  }

  public void OnCloseFile() {
    FIsOpened = false;
    super.OnCloseFile();
  }

  public boolean IsOpened() {
    return FIsOpened && (getCount() > 0);
  }

  public void PrintItems() {
    System.out.println("FIsOpened = " + FIsOpened);
    super.PrintItems();
  }

}
