/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options.manager;

import java.lang.*;
import java.io.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.opened.*;
import org.freebuilder.system.classes.events.engine.IdeEventsEngine;

/** <code>MainConfig</code> represents the main configuration for the IDE. If have also a
  * collection StrinList of the latest opened project files.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class MainConfig extends ProjectConfig {
  // public final static String cDefaultConfigFileName = "JFBuilder.cfg";
  private final static String cMainRecentFilesOName = "Reopen Main Files";
  public  final static String cRecentProjectsOName  = "Reopen Projects";

  public MainConfig(IdeEventsEngine AEventsEngine, String AConfigFileName, CreateDOptionsListener DOptionsCreateObject) {
    super(AEventsEngine, AConfigFileName, DOptionsCreateObject);
  }

  protected String getOFilesOptionsName() { return cMainRecentFilesOName;    };

  public void CreateDefaultConfig() {
    StrLLastProjects LastOpenedProjcets = new StrLLastProjects(cRecentProjectsOName);
    super.CreateDefaultConfig();
    try { // Add Cloned object to OptionsCollection. Otherwise isDiffrent always return false
      addOptions(LastOpenedProjcets);
    }
    catch (DuplicateOptionNameException e) {
      Debug.Assert(e,this," in MainConfig.CreateDefaultConfig ");
    };
  }

  /** Returns a collection of last opened project files */
  public StrLLastProjects getLastOpenedProjectFiles() {
    return (StrLLastProjects)getOptions(cRecentProjectsOName);
  }

  /** Was the project opened the last time you close the application */
  public boolean  WasLastProjectOpened() {
    StrLLastProjects LastPs = getLastOpenedProjectFiles(); if (LastPs == null) return false;
    return LastPs.IsOpened();
  }

  /** Add AFileName to the collection of last opened files at first place */
  public boolean OpenProject(String AFileName) {
    StrLLastProjects LastPs = getLastOpenedProjectFiles(); if (LastPs == null) return false;
    LastPs.OnOpenFile(AFileName);
    setOptions(LastPs);
    return true;
  }

  public void    CloseLastProject() { // Only 1 project will be opened at a time.
    StrLLastProjects LastPs = getLastOpenedProjectFiles(); if (LastPs == null) return;
    LastPs.OnCloseFile();
    setOptions(LastPs);
  }

  public String getLastProjectFileName() {
    StrLLastProjects LastPs = getLastOpenedProjectFiles(); if (LastPs == null) return "";
    if (LastPs.getCount() == 0) return "";
    return LastPs.getString(0);
  }

  /** for test only */
  public void PrintOptions() {
    StrLLastProjects LastOPrFiles = (StrLLastProjects)(getOptions(cRecentProjectsOName));

    super.PrintOptions();
    if (LastOPrFiles != null) {
      System.out.println("");
      System.out.println("Last Opened Projects");
      LastOPrFiles.PrintItems();
    }
  }
}
