/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

import java.util.EventObject;

/** The class <code>IdeSuperEvent</code>
  * This is the super class for all the events which will be Dispatched via IdeEventsEngin
  * Every new Event have to derive from IdeSuperEvent.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */
  
public class IdeSuperEvent extends EventObject implements IdeSuperEventI {
  protected EventObject Event;
  protected int         EventPass;
  protected boolean     Handled = false;

  public IdeSuperEvent(EventObject Event) {
    super(Event.getSource());
    this.Event = Event;
    setEventPass(2);
    Handled = false;
  }

  /** @return the actual event */
  public EventObject getEvent()     { return Event; }

  /** @return Event's sender  = getEvent.getSource() */
  public Object      getEventSender() {
    if (Event == null) return null;
    return Event.getSource();
  }

  /** @return 1 - for BeforeAction, 2 - OnAction, 3 - AfterAction */
  public int         getEventPass() { return EventPass; }

  /** This function is called only by EventEngine object */
  public void        setEventPass(int AEventPass) { EventPass = AEventPass; }

  /** @return true if the event is handled by a listener */
  public boolean     isHandled()    { return Handled; }

  /** This function is called only by EventEngine object */
  public void        SetHandled()   { Handled = true; }
}

