/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

/** The class <code>IdeEvensListColl</code> supports a List of IdeEventsList objects.
  * Every IdeEventsList is dedicated for some Event Class and eventually it's subclasses.
  * Events are grouped by their kinds. Kind of event is it's Class ( SomeEvent.getClass() )
  * Every listener handle some Kind of events.
  *    if the listener wants to handle also all deriveted from this class events,
  *    SomeListener.isChildEventsListener() have to return true.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

class IdeEvensListColl {
  IdeEvensList TheList;      // Reference to the beginig of the list
  int          MethodNumber; // < 0 - BeforeAction, 0 - DoAction, > 0 - AfterAction

  IdeEvensListColl (int WhichMethodToCall) { /** < 0 - BeforeAction, 0 - DoAction, > 0 - AfterAction */
    TheList      = null;
    MethodNumber = WhichMethodToCall;
  }

  IdeEventListenerI findListener(IdeEventListenerI EventListener) {
    IdeEventListenerI Result   = null;
    IdeEvensList      CrntList = TheList;

    while (CrntList != null) {
      Result = CrntList.findListener(EventListener);
      if (Result != null) break;
      CrntList = CrntList.getNext();
    }
    return Result;
  }

  IdeEvensList findEventClassList(Class eClass) {
    IdeEvensList Result = TheList;

    while (Result != null) {
      if (Result.getEventsBaseClass() == eClass)
        return Result;

      Result = Result.getNext();
    }
    return Result;
  }

  /** EventListeners are added from the beggining of the list.
      Last added Listeners will be searched first
      This method shall be called only from synchronized function
  */
  void AddEventListener(IdeEventListenerI EventListener) {
    Class elClass;
    boolean isChildEvents;

    IdeEvensList CrntEventsList = null;

    if (EventListener == null) return;

    elClass       = EventListener.getEventsClass();
    isChildEvents = EventListener.isChildEventsListener();

    // if there is a List wich match this class, this listener will be added to this list.
    CrntEventsList = findEventClassList(elClass);
    if (CrntEventsList != null) {
      CrntEventsList.AddEventListener(EventListener);
      return;
    }

    CrntEventsList = new IdeEvensList(elClass);
    CrntEventsList.AddEventListener(EventListener);
    CrntEventsList.PutBefore(TheList);
    TheList = CrntEventsList;
  }

  /** Removes list of listeners This method shall be called only from synchronized function */
  void RemoveEventListener(IdeEventListenerI EventListener) {
    IdeEvensList CrntList = TheList;

    while (CrntList != null) {
      if (CrntList.RemoveEventListener(EventListener)) {

        if (CrntList.EventsList == null)  // if this list is empty with listeners
          CrntList.Remove();              // remove the list

        if (TheList == CrntList)         // if this is the root list
          TheList = CrntList.getNext(); // change the root list
        return;
      }
      CrntList = CrntList.getNext();
    }
  }

  /** Dispatches all the messages */
  void DispatchEvent(Class AEventClass, IdeSuperEvent TheEvent, boolean JustCheck) {
    IdeEvensList CrntList;

    CrntList = TheList;
    while (CrntList != null) {
      CrntList.DispatchEvent(AEventClass, TheEvent,MethodNumber, JustCheck);
      CrntList = CrntList.getNext();
    }
  }
}


