/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.ideoptions;

import org.freebuilder.gui.config.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.events.*;

import org.freebuilder.gui.beans.*;

import java.util.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class JavaDOCOptions implements OptionsSuperI, Cloneable {
  public static final String JavaDOCOptionsName = "JavaDOC Options";

  public static final int PUBLIC    = 0;
  public static final int PROTECTED = 1;
  public static final int PACKAGE   = 2;
  public static final int PRIVATE   = 3;

  private boolean Version;
  private boolean NoDeprecated;
  private boolean Author;
  private boolean NoIndex;
  private boolean NoTree;
  private int ShowFlags;

  public boolean getVersion () {
    return Version;
  }
  public void setVersion (boolean Version) {
    this.Version = Version;
  }

  public boolean getNoDeprecated () {
    return NoDeprecated;
  }
  public void setNoDeprecated (boolean NoDeprecated) {
    this.NoDeprecated = NoDeprecated;
  }

  public boolean getAuthor () {
    return Author;
  }
  public void setAuthor (boolean Author) {
    this.Author = Author;
  }

  public boolean getNoIndex () {
    return NoIndex;
  }
  public void setNoIndex (boolean NoIndex) {
    this.NoIndex = NoIndex;
  }

  public boolean getNoTree () {
    return NoTree;
  }
  public void setNoTree (boolean NoTree) {
    this.NoTree = NoTree;
  }

  public int getShowFlags () {
    return ShowFlags;
  }
  public void setShowFlags (int ShowFlags) {
    if ((ShowFlags == PUBLIC) ||
        (ShowFlags == PROTECTED) ||
        (ShowFlags == PACKAGE) ||
        (ShowFlags == PRIVATE))
      this.ShowFlags = ShowFlags;
  }


  public OptionsSuperI Clone() throws CloneNotSupportedException {
    JavaDOCOptions ClonedOptions = (JavaDOCOptions) clone();
    return ClonedOptions;
  }

  public boolean IsDifferent(OptionsSuperI TheOtherOne) {
    JavaDOCOptions Other = (JavaDOCOptions) TheOtherOne;
    if (Other.getVersion ()       != getVersion ())
      return true;
    if (Other.getAuthor ()        != getAuthor ())
      return true;
    if (Other.getNoDeprecated ()  != getNoDeprecated ())
      return true;
    if (Other.getNoIndex ()       != getNoIndex ())
      return true;
    if (Other.getNoTree ()        != getNoTree ())
      return true;
    if (Other.getShowFlags ()     != getShowFlags ())
      return true;

    return false;
  }

  public String getName() {
    return JavaDOCOptionsName;
  }

  public void setDefaults() {
    setVersion       (true);
    setAuthor        (true);
    setNoDeprecated  (false);
    setNoIndex       (false);
    setNoTree        (false);
    setShowFlags     (PROTECTED);
  }

  public OptionsEvent PrepareEvent(int EventNumber) {
    return new OptionsEvent(EventNumber, new EventObject(this), this);
  }

  public String [] getOptions () {
    Vector Opts           = new Vector();
    PathsOptions POptions = (PathsOptions) Globals.Options.getOptions(PathsOptions.PathsOptionsName);
    String TheClassPath   = PathEditorDialog.getPath (POptions.getClassPath());
    String TheSourcePath  = PathEditorDialog.getPath (POptions.getSourcePath());

//    Opts.addElement ("-classpath");
//    Opts.addElement (TheClassPath);
//    Opts.addElement ("javadoc.exe");
    Opts.addElement ("-sourcepath");
    Opts.addElement (TheSourcePath+";"+TheClassPath);
    Opts.addElement ("-d");
    Opts.addElement (POptions.getJavaDOCOutPath());
    if (getVersion())
      Opts.addElement ("-version");
    if (getAuthor())
      Opts.addElement ("-author");
    if (getNoIndex())
      Opts.addElement ("-noindex");
    if (getNoTree())
      Opts.addElement ("-notree");
    switch (getShowFlags()) {
      case PUBLIC:
        Opts.addElement ("-public");
      break;
      case PRIVATE:
        Opts.addElement ("-private");
      break;
      case PACKAGE:
        Opts.addElement ("-package");
      break;
      case PROTECTED:
        Opts.addElement ("-protected");
      break;
    }
    String[] Ret = new String[Opts.size()];
    Opts.copyInto(Ret);
    return Ret;
  }
}

/*
 -sourcepath <path>  Colon-separated list of source-file directories
 -classpath <path>   Synonym for -sourcepath
 -d <directory>      Destination directory for output files
 -version            Include @version paragraphs
 -nodeprecated       Exclude @deprecated paragraphs
 -author             Include @author paragraphs
 -noindex            Do not generate method and field index
 -notree             Do not generate class hierarchy
 -public             show only public classes and members
 -protected          show protected/public classes and members (default)
 -package            show package/protected/public classes and members
 -private            show all classes and members
*/
