/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.manager.*;
import org.freebuilder.system.classes.options.opened.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.gui.beans.*;

import java.util.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class ReopenMenuMan {
  private int ProjectFirst;
  private int FileFirst;
  private Vector Listeners = new Vector();

  public ReopenMenuMan () {
    OptionsEventAdapter ReopenProjectsChangedAdapter = null;
    OptionsEventAdapter ReopenFilesChangedAdapter    = null;
    OptionsEventAdapter ReopenProjectsRefreshAdapter = null;
    OptionsEventAdapter ReopenFilesRefreshAdapter    = null;
    try {
      ReopenProjectsRefreshAdapter =
          new OptionsEventAdapter(MainConfig.cRecentProjectsOName, OptionsEvent.msgOptionsRefresh,
                                  IdeEventListenerI.CALL_MASK, this, "getCurrentOptions");
      ReopenProjectsChangedAdapter =
          new OptionsEventAdapter(MainConfig.cRecentProjectsOName, OptionsEvent.msgOptionsChanged,
                                  IdeEventListenerI.CALL_MASK, this, "getCurrentOptions");

      ReopenFilesRefreshAdapter    =
          new OptionsEventAdapter(MainConfig.cRecentFilesOName, OptionsEvent.msgOptionsRefresh,
                                  IdeEventListenerI.CALL_MASK, this, "getCurrentOptions");
      ReopenFilesChangedAdapter    =
          new OptionsEventAdapter(MainConfig.cRecentFilesOName, OptionsEvent.msgOptionsChanged,
                                  IdeEventListenerI.CALL_MASK, this, "getCurrentOptions");
    } catch (NoSuchMethodException e) {
      Debug.Assert (e, this, "MainPanel : No such Method.");
    }

    Globals.EventsEngine.AddEventListener(ReopenProjectsRefreshAdapter);
    Globals.EventsEngine.AddEventListener(ReopenProjectsChangedAdapter);
    Globals.EventsEngine.AddEventListener(ReopenFilesRefreshAdapter);
    Globals.EventsEngine.AddEventListener(ReopenFilesChangedAdapter);
  }

  public void getCurrentOptions (IdeSuperEvent AEvent) {
    StrLLastProjects LastProjects = (StrLLastProjects) Globals.Options.getOptions (MainConfig.cRecentProjectsOName);
    StrItems LastFiles            = (StrItems)         Globals.Options.getOptions (MainConfig.cRecentFilesOName);
    IdeMenu ReopenMenu = (IdeMenu) Globals.MainMenu.FindMenu (IdeMainMenu.msgmiFileReopen);
    int MsgNo = IdeMainMenu.LastMainMenuMgsNo;
    int i = 0;
    while (ReopenMenu.getMenuComponentCount() > 0)
      ReopenMenu.remove(0);

    for (i = 0; i < Listeners.size(); i++)
      Globals.EventsEngine.RemoveEventListener ((IdeEventListenerI) Listeners.elementAt(i));

    Listeners.removeAllElements();

    IdeMenuItem DumyItem;
    DumyItem = Globals.MainMenu.AddMItemTo (ReopenMenu, -1, "Resently Opened Files", true);
    DumyItem.setEnabled (false);

    FileFirst = MsgNo;
    if (LastFiles != null)
     for (i = 0; i < LastFiles.getCount(); i++, MsgNo++) {
        Globals.MainMenu.AddMItemTo (ReopenMenu, MsgNo, LastFiles.getString(i), true);
        Listeners.addElement(Globals.IEngine.AddMainMenuAdapter (MsgNo, this,"reopenFile"));
     }

    ReopenMenu.addSeparator();

    DumyItem = Globals.MainMenu.AddMItemTo (ReopenMenu, -1, "Resently Opened Projects", true);
    DumyItem.setEnabled (false);

    ProjectFirst = MsgNo;
    if (LastProjects != null)
      for (i = 0; i < LastProjects.getCount(); i++, MsgNo++) {
        Globals.MainMenu.AddMItemTo (ReopenMenu, MsgNo, LastProjects.getString(i), true);
        Listeners.addElement(Globals.IEngine.AddMainMenuAdapter (MsgNo, this,"reopenProject"));
      }
  }

  public void reopenProject (IdeSuperEvent AEvent) {
    int SelectedProjectNo = ((MainMenuEvent) AEvent).EventID - ProjectFirst;
    String SelectedProjectName = ((StrLLastProjects)Globals.Options.getOptions (MainConfig.cRecentProjectsOName)).getString (SelectedProjectNo);
    while (!Globals.PManager.OpenProject(SelectedProjectName))
      if (Misc.messageBox (new String [] {"Retry", "Cancel"}, new String [] {"Unable to open project" + SelectedProjectName}, 1) == 1)
        break;
  }

  public void reopenFile (IdeSuperEvent AEvent) {
    int SelectedFileNo = ((MainMenuEvent) AEvent).EventID - FileFirst;
    String SelectedFileName = ((StrItems) Globals.Options.getOptions (MainConfig.cRecentFilesOName)).getString (SelectedFileNo);
    Globals.IEngine.doOpenFile (SelectedFileName);
  }
}

















