/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import java.awt.*;
import java.awt.event.*;

/** The <code>EnDisableI</code> interface will be used for enable/disable IdeMenu, IdeMenuItems,
  * and SpeedButtons.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 07-01-98 */

public interface EnDisableI {
  public void    setEnabled(boolean Enable);
  public boolean isEnabled();
  /** This method double the purpose of isEnable(), except that it executes all the
    * neccessary methods to discover the status and set that status to some
    * internal variable. isEnabled just returns this variable value.
    * if it is not a big waste of time, isEnabled could call RefreshIsEnabled() every time.
    */
  public boolean RefreshIsEnabled();
  /** This method is called when the IdeMenuItem, or IdeMenu is Removed from Menu */
  public void    RemoveFromMenu();
  public void    AddToMenu();
  /** Returns the number of event this MenuItem, Menu or Speed button will send */
  public int     getCmndNumber();
}

