/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.editors;

import java.lang.reflect.*;
import java.lang.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.beans.*;
import java.io.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class ClassBrowser {
  private PrintWriter Printer;

  private void addFeature (FeatureDescriptor FD) {
    Printer.println ("Programatic Name : " + FD.getName());
    Printer.println ("DisplayName Name : " + FD.getDisplayName());
    Printer.println ("Short Description : " + FD.getShortDescription());
    Printer.println ("Hidden : " + FD.isHidden());
    Printer.println ("Expert : " + FD.isExpert());
    Printer.println ("Attributes");
    for (Enumeration e = FD.attributeNames();e.hasMoreElements();) {
      String AnAttribute = (String) e.nextElement();
      Printer.println (AnAttribute + " : " + FD.getValue(AnAttribute));
    }
  }

  private void addBeanDescriptor (BeanDescriptor BD) {
    Printer.println ("Descriptor");
    addFeature (BD);

    Printer.println ("Bean Class : " + BD.getBeanClass().getName());

    Class Customizer = BD.getCustomizerClass();
    if (Customizer == null)
      Printer.println ("No Customizer");
    else
      Printer.println ("Bean Customizer : " + Customizer.getName());
  }

  private void addProperties (PropertyDescriptor Props[]) {
    int i;
    Printer.println ("Properties");
    for (i=0;i<Props.length;i++) {
      Printer.println (Props[i].getShortDescription());
      Printer.println (Props[i]);
      Class EditorClass = Props[i].getPropertyEditorClass();
      if (EditorClass == null)
        Printer.println ("No Editor");
      else
        Printer.println ("Editor : " + EditorClass.getName());

      Class PropType = Props[i].getPropertyType();
      if (PropType != null)
        Printer.println ("Type : " + PropType.getName());
      else
        Printer.println ("Type : Indexed ");

      Method RMethod = Props[i].getReadMethod();
      if (RMethod != null) {
        Printer.println ("Read Method");
        MethodProcessor (new Method[] {RMethod}, false);
      }
      else
        Printer.println ("Read Method : None");


      Method WMethod = Props[i].getWriteMethod();
      if (WMethod != null) {
        Printer.println ("Write Method");
        MethodProcessor (new Method[] {WMethod}, false);
      }
      else
        Printer.println ("Write Method : None");

      Printer.println ("Bound : " + Props[i].isBound());
      Printer.println ("Constrained : " + Props[i].isConstrained());
    }
  }

  private void addEvents (EventSetDescriptor Events[]) {
    int i;
    Printer.println ("Events");
    for (i=0;i<Events.length;i++) {
      Printer.println (Events[i].getShortDescription());
      addFeature (Events[i]);

      Printer.println ("Add Listener Method");
      MethodProcessor (new Method[] {Events[i].getAddListenerMethod()}, false);

      Printer.println ("Remove Listener Method");
      MethodProcessor (new Method[] {Events[i].getRemoveListenerMethod ()}, false);

      Printer.println ("Listener Type : " + Events[i].getListenerType().getName());

      Printer.println ("Listener Methods");
      MethodProcessor (Events[i].getListenerMethods(), false);

//      getListenerMethodDescriptors();  The same as above...

      Printer.println ("In Default Event Set : " + Events[i].isInDefaultEventSet());
      Printer.println ("Unicast : " + Events[i].isUnicast());
    }
  }

  private void addMethods (MethodDescriptor Methods[]) {
    int i;
    Printer.println ("Methods");

    for (i=0; i<Methods.length; i++) {
      Printer.println (Methods[i].getShortDescription());
      addFeature (Methods[i]);
      MethodProcessor (new Method[] {Methods[i].getMethod()}, false);
    }
  }

  private void addIcons (BeanInfo BI) {
    String Yes = "Present";
    String No = "Absent";
    Printer.println ("Icon Color 32x32 : " + (BI.getIcon(BI.ICON_COLOR_32x32) != null ? Yes : No));
    Printer.println ("Icon Color 16x16 : " + (BI.getIcon(BI.ICON_COLOR_16x16) != null ? Yes : No));
    Printer.println ("Icon Mono 32x32 : " + (BI.getIcon(BI.ICON_MONO_32x32) != null ? Yes : No));
    Printer.println ("Icon Mono 16x16 : " + (BI.getIcon(BI.ICON_MONO_16x16) != null ? Yes : No));
  }

  private void addBeanInfo (BeanInfo BI) {
    int i,AdditionalBIcount;

    addIcons (BI);
    addBeanDescriptor (BI.getBeanDescriptor());
    addProperties (BI.getPropertyDescriptors());
    addEvents (BI.getEventSetDescriptors());
    addMethods (BI.getMethodDescriptors());
    BeanInfo [] MoreBI = BI.getAdditionalBeanInfo();
    Printer.println ("Additional Bean Info");
    AdditionalBIcount = MoreBI == null ? 0 : MoreBI.length;
    for (i=0; i < AdditionalBIcount; i++)
      addBeanInfo (MoreBI[i]);
  }

  private void addReflection (Class CurrentClass) {
//System.out.println (".......................Adding Interfaces.......................");
    addInterfaces       (CurrentClass.getInterfaces());
//System.out.println (".......................Interfaces Added........................");
    Printer.println (" {");
//System.out.println (".......................Adding Constructors.....................");
    Constructor [] DConstructors = CurrentClass.getDeclaredConstructors();
//System.out.println (".......................Constructors Added......................");
    addConstructors     (DConstructors);
//System.out.println (".......................Adding Fields...........................");
    addFields           (CurrentClass.getDeclaredFields());
//System.out.println (".......................Fields Added............................");
//System.out.println (".......................Adding Methods..........................");
    addMethods          (CurrentClass.getDeclaredMethods());
//System.out.println (".......................Methods Added...........................");
//    addAllPublicFields  (CurrentClass.getFields());
//    addAllPublicMethods (CurrentClass.getMethods());
    Printer.println ("}");
  }

  public String showClass (Class CurrentClass) {
    StringWriter Data = new StringWriter ();
    Printer = new PrintWriter (Data);
    doShowClass (CurrentClass);
    return Data.getBuffer().toString();
  }

  public void doShowClass (Class CurrentClass) {
    addModifiers (CurrentClass.getModifiers());
    if (CurrentClass.isInterface())
      Printer.print ("interface ");
    else
      Printer.print ("class ");
    Printer.print (CurrentClass.getName());
    if ((CurrentClass.getSuperclass() != (new Object()).getClass()) &&
        (CurrentClass.getSuperclass() != null))
      Printer.print (" extends "+CurrentClass.getSuperclass().getName());
//System.out.println (".......................Adding Reflection.......................");
    addReflection (CurrentClass);
//System.out.println (".......................Reflection Added........................");
//System.out.println ("Adding Inner Classes.");
    Class [] Inner = CurrentClass.getDeclaredClasses();
    if (Inner != null)
      for (int i = 0; i < Inner.length; i++)
        doShowClass (Inner[i]);
//System.out.println ("Inner Classes Added.");
/*
    BeanInfo BI = null;
    try {
      BI = Introspector.getBeanInfo (CurrentClass);
    } catch (Exception e) {return;}
    addBeanInfo   (BI);
*/
  }

  private void addReturnType (Method TheMethod) {
    Class Ret = TheMethod.getReturnType();
    recAddType (Ret);
    Printer.print(" ");
  }

  private void addParameterTypes (Method TheMethod) {
    Class Params[] = TheMethod.getParameterTypes();
    int i;
    Printer.print ("(");
    for (i=0; i<Params.length;i++) {
      recAddType (Params[i]);
      if (i < Params.length-1)
        Printer.print (", ");
    }
    Printer.print (")");
  }

  private void addParameterTypes (Constructor TheConstructor) {
    Class Params[] = TheConstructor.getParameterTypes();
    int i;
    Printer.print ("(");
    for (i=0; i<Params.length;i++) {
      recAddType (Params[i]);
      if (i < Params.length-1)
        Printer.print (", ");
    }
    Printer.print (")");
  }

  private void addExeptionTypes (Method TheMethod) {
    Class Exceptions[] = TheMethod.getExceptionTypes();
    if (Exceptions.length > 0)
      Printer.print (" throws ");
    int i;
    for (i=0; i<Exceptions.length;i++) {
      Printer.print (Exceptions[i].getName());
      if (i < Exceptions.length-1)
        Printer.print (", ");
    }
  }

  private void addExeptionTypes (Constructor TheConstructor) {
    Class Exceptions[] = TheConstructor.getExceptionTypes();
    if (Exceptions.length > 0)
      Printer.print (" throws ");
    int i;
    for (i=0; i<Exceptions.length;i++) {
      Printer.print (Exceptions[i].getName());
      if (i < Exceptions.length-1)
        Printer.print (", ");
    }
  }

  private void addName (Field TheField) {
    Printer.print (TheField.getName());
  }

  private void recAddType (Class Type) {
    if (Type.isArray()) {
      recAddType (Type.getComponentType());
      Printer.print ("[]");
    } else
      Printer.print (Type.getName());
  }

  private void addType (Field TheField) {
    Class FieldType = TheField.getType();
    recAddType(FieldType);
    Printer.print (" ");
  }

  private void addName (Method TheMethod) {
    Printer.print (TheMethod.getName()+" ");
  }

  private void addName (Constructor TheConstructor) {
    Printer.print (TheConstructor.getName()+" ");
  }

  private void addModifiers (int Modifiers) {
    if (Modifier.isPublic(Modifiers))
      Printer.print ("public ");
    if (Modifier.isPrivate(Modifiers))
      Printer.print ("private ");
    if (Modifier.isProtected(Modifiers))
      Printer.print ("protected ");
    if (Modifier.isStatic(Modifiers))
      Printer.print ("static ");
    if (Modifier.isFinal(Modifiers))
      Printer.print ("final ");
    if (Modifier.isSynchronized(Modifiers))
      Printer.print ("synchronized ");
    if (Modifier.isVolatile(Modifiers))
      Printer.print ("volatile ");
    if (Modifier.isTransient(Modifiers))
      Printer.print ("transient ");
    if (Modifier.isNative(Modifiers))
      Printer.print ("native ");
    if (Modifier.isAbstract(Modifiers))
      Printer.print ("abstract ");
    if (Modifier.isInterface(Modifiers))
      Printer.print ("interface ");
  }

  private void MethodProcessor (Method Methods[], boolean Derived) {
    int i,j;
    for (i = 0;i < Methods.length;i++) {
      Printer.print ("    ");
      addModifiers (Methods[i].getModifiers());
      addReturnType (Methods[i]);
      addName (Methods[i]);
      addParameterTypes (Methods[i]);
      addExeptionTypes (Methods[i]);
      Printer.println (";");
      if (Derived)
        Printer.println ("                              //Declared in " + Methods[i].getDeclaringClass().getName());
    }
  }

  private void addMethods (Method DeclaredMethods[]) {
    Printer.println ("//Declared Methods");
    MethodProcessor (DeclaredMethods, false);
  }

  private void addAllPublicMethods (Method AllPublicMethods[]) {
    Printer.println ("//All Public Methods");
    MethodProcessor (AllPublicMethods, true);
  }

  private void FieldProcessor (Field Fields[], boolean Derived) {
    int i,j;
    for (i = 0;i < Fields.length;i++) {
      Printer.print ("    ");
      addModifiers (Fields[i].getModifiers());
      addType (Fields[i]);
      addName (Fields[i]);
      Printer.println (";");
      if (Derived)
        Printer.println ("                              //Declared in " + Fields[i].getDeclaringClass().getName());
    }
  }

  private void addFields (Field DeclaredFields[]) {
    Printer.println ("//Declared Fields");
    FieldProcessor (DeclaredFields, false);
  }

  private void addAllPublicFields (Field AllPublicFields[]) {
    Printer.println ("//All Public Fields");
    FieldProcessor (AllPublicFields, true);
  }

  private void addConstructors (Constructor DeclaredConstructors[]) {
    int i;
    Printer.println ("//Constructors");
    for (i = 0;i < DeclaredConstructors.length;i++) {
//      Printer.println (DeclaredConstructors[i].toString());
      Printer.print ("        ");
//System.out.println (".......................Adding Modifiers.......................");
      addModifiers (DeclaredConstructors[i].getModifiers());
//System.out.println (".......................Modifiers Added........................");
      addName (DeclaredConstructors[i]);
      addExeptionTypes (DeclaredConstructors[i]);
      addParameterTypes (DeclaredConstructors[i]);
      Printer.println (";");
    }
  }

  private void addInterfaces (Class DeclaredInterfaces[]) {
    int i;
    if (DeclaredInterfaces.length > 0)
      Printer.print (" implements ");
    for (i = 0;i < DeclaredInterfaces.length;i++) {
      Printer.print (DeclaredInterfaces[i].getName());
      if (i < DeclaredInterfaces.length-1)
        Printer.print (", ");
    }
  }
}

