/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.options.manager.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class PizzaOptionsPanel extends BPanel implements ItemListener, Configurator {
  private JCheckBox Experimental    = new JCheckBox ("Enable experimental features");
  private JCheckBox Debug           = new JCheckBox ("Include debug information");

  private ButtonGroup AcceptWhat      = new ButtonGroup();
  private JRadioButton JavaOnly       = new JRadioButton ("Accept only standard Java input", false);
  private JRadioButton Pizza          = new JRadioButton ("Accept standard Pizza input",     true);

  private JCheckBox Emit              = new JCheckBox ("Emit java sources instead of classfiles");
  private JCheckBox Scramble          = new JCheckBox ("Scramble private identifiers in bytecode");
  private JCheckBox ScrambleAll       = new JCheckBox ("Scramble package visible identifiers in bytecode");
  private JCheckBox SwitchCheck       = new JCheckBox ("Warn about fall-through in switches");
  private JCheckBox Verbose           = new JCheckBox ("Print detailed log");
  private JCheckBox Version           = new JCheckBox ("Print compiler version information");
  private JCheckBox PrintSearch       = new JCheckBox ("Print information where classfiles are searched");
  private BPanel PathsPanel           = new BPanel   ("Paths");
  private JPanel BrowsablePathsPanel  = new JPanel    ();

  public PizzaOptionsPanel () {
    super("Pizza Compiler Options");

    BPanel Options     = new BPanel ("Flags");
    BPanel Accept      = new BPanel ("Accept");
    JPanel LeftOptions  = new JPanel ();
    JPanel RightOptions = new JPanel ();
    JPanel MainPanel    = new JPanel ();

    AcceptWhat.add (JavaOnly);
    AcceptWhat.add (Pizza);

    LeftOptions.setLayout (new GridLayout(4, 1, 0, 0));
    LeftOptions.add (Experimental);
    LeftOptions.add (Debug);
    LeftOptions.add (Emit);
    LeftOptions.add (Scramble);

    RightOptions.setLayout (new GridLayout(5, 1, 0, 0));
    RightOptions.add (ScrambleAll);
    RightOptions.add (SwitchCheck);
    RightOptions.add (Verbose);
    RightOptions.add (Version);
    RightOptions.add (PrintSearch);

    Options.setLayout (new BorderLayout());
    Options.add (LeftOptions,  BorderLayout.WEST);
    Options.add (RightOptions, BorderLayout.EAST);

    Accept.setLayout (new GridLayout(1, 2, 1, 1));
    Accept.add (JavaOnly);
    Accept.add (Pizza);

    PathsPanel.setLayout          (new GridLayout(2, 1, 3, 3));
    BrowsablePathsPanel.setLayout (new GridLayout(1, 2, 3, 3));

    MainPanel.setLayout (new BorderLayout());
    MainPanel.add (Options, BorderLayout.NORTH);
    MainPanel.add (Accept,  BorderLayout.SOUTH);
    setLayout (new BorderLayout());
    add (MainPanel, BorderLayout.NORTH);
    add (PathsPanel, BorderLayout.SOUTH);
    Emit.addItemListener (this);
    getOptions ();
  }

  public String toString () {
    return "Pizza Compiler";
  }

  public void itemStateChanged (ItemEvent e) {
    if (e.getSource().equals(Emit))
      PathsOptionsConfig.setEnabledPanel(PathsOptionsConfig.getPizzaSourceOutPathPanel(), Emit.isSelected());
  }

  public void setPaths () {
    PathsPanel         .removeAll();
    BrowsablePathsPanel.removeAll();
    BrowsablePathsPanel.add (PathsOptionsConfig.getClassOutPathPanel ());
    BrowsablePathsPanel.add (PathsOptionsConfig.getPizzaSourceOutPathPanel ());
    PathsPanel.add (PathsOptionsConfig.getClassPathPanel ());
    PathsPanel.add (BrowsablePathsPanel);
  }

  public void initGUI () {
    setPaths();
  }

  public Component getGUI () {
    return this;
  }

  public void getOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    PizzaCompilerOptions NewOptions = (PizzaCompilerOptions) (AOptions.getOptions(PizzaCompilerOptions.PizzaCompilerOptionsName));
    Emit        .setSelected(NewOptions.isEmit());
    Debug       .setSelected(NewOptions.isDebug());
    Verbose     .setSelected(NewOptions.isVerbose());
    Version     .setSelected(NewOptions.isVersion());
    JavaOnly    .setSelected(NewOptions.isJavaOnly());
    Pizza       .setSelected(!NewOptions.isJavaOnly());
    Scramble    .setSelected(NewOptions.isScramble());
    ScrambleAll .setSelected(NewOptions.isScrambleAll());
    SwitchCheck .setSelected(NewOptions.isSwitchCheck());
    Experimental.setSelected(NewOptions.isExperimental());
    PrintSearch .setSelected(NewOptions.isPrintSearch());
    itemStateChanged (new ItemEvent(Emit, 0, Emit, Emit.isSelected()?ItemEvent.SELECTED:ItemEvent.DESELECTED));
  }

  public void setOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    PizzaCompilerOptions NewOptions = (PizzaCompilerOptions) (AOptions.getOptions(PizzaCompilerOptions.PizzaCompilerOptionsName));
    NewOptions.setEmit         (Emit.isSelected());
    NewOptions.setDebug        (Debug.isSelected());
    NewOptions.setVerbose      (Verbose.isSelected());
    NewOptions.setVersion      (Version.isSelected());
    NewOptions.setJavaOnly     (JavaOnly.isSelected());
    NewOptions.setScramble     (Scramble.isSelected());
    NewOptions.setScrambleAll  (ScrambleAll.isSelected());
    NewOptions.setSwitchCheck  (SwitchCheck.isSelected());
    NewOptions.setExperimental (Experimental.isSelected());
    NewOptions.setPrintSearch  (PrintSearch.isSelected());
    AOptions.setOptions (NewOptions);
  }
}


