/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.options.manager.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class DebuggerOptionsPanel extends BPanel implements ItemListener, ActionListener, Configurator {
  private BPanel MainPanel               = new BPanel();
  private BPanel CommandLinePanel        = new BPanel("Cammnd Line Parameters:");
  private BPanel OptionsPanel            = new BPanel("Java VM Options:");
  private BPanel FlagsPanel              = new BPanel("Flags");
  private BPanel ChecksPanel             = new BPanel();
  private BPanel VerifyPanel             = new BPanel("Verify:");
  private BPanel ProfilePanel            = new BPanel("Profiling:");
  private JTextField Params              = new JTextField();

  private JCheckBox Verbose               = new JCheckBox("Turn on verbose mode");
  private JCheckBox Debug                 = new JCheckBox("Enable remote JAVA debugging");
  private JCheckBox NoAsync               = new JCheckBox("Don\'t allow asynchronous garbage collection");
  private JCheckBox VerboseGC             = new JCheckBox("Print a message when garbage collection occurs");
  private JCheckBox NoClassGC             = new JCheckBox("Disable class garbage collection");

  private ButtonGroup Verify             = new ButtonGroup();
  private JRadioButton VerifyAll         = new JRadioButton("Verify all classes when read in",         false);
  private JRadioButton VerifyRemote      = new JRadioButton("Verify classes read in over the network", true);
  private JRadioButton VerifyNone        = new JRadioButton("Do not verify any class",                 false);

  private ButtonGroup Profile          = new ButtonGroup();
  private JRadioButton ProfileNone          = new JRadioButton ("No profiling data",                       true);
  private JRadioButton ProfileDef           = new JRadioButton ("Output profiling data to .\\java.prof",   false);
  private JRadioButton ProfileHere          = new JRadioButton ("Output profiling data to:",               false);

  private JTextField UserProfile         = new JTextField();

  private JButton EditMemorySizesButton  = new JButton ("Memory Sizes");

  private String NativeStack;
  private String JavaStack;
  private String InitialHeap;
  private String JavaHeap;

  private boolean DefNativeStack;
  private boolean DefJavaStack;
  private boolean DefInitialHeap;
  private boolean DefJavaHeap;

  public DebuggerOptionsPanel () {

    CommandLinePanel.setLayout     (new BorderLayout());
    CommandLinePanel.add           (Params);

    Verify.add (VerifyAll);
    Verify.add (VerifyRemote);
    Verify.add (VerifyNone);

    Profile.add (ProfileNone);
    Profile.add (ProfileDef);
    Profile.add (ProfileHere);

    FlagsPanel.setLayout (new GridLayout(5, 1));
    FlagsPanel.add (Verbose);
    FlagsPanel.add (Debug);
    FlagsPanel.add (NoAsync);
    FlagsPanel.add (VerboseGC);
    FlagsPanel.add (NoClassGC);

    MainPanel.setLayout (new BorderLayout());
    MainPanel.setInner  (BPanel.NONE);
    MainPanel.setOuter  (BPanel.NONE);
    setMainPanel ();

    VerifyPanel.setLayout (new GridLayout (3, 1));
    VerifyPanel.add (VerifyAll);
    VerifyPanel.add (VerifyRemote);
    VerifyPanel.add (VerifyNone);

    ProfilePanel.setLayout (new GridLayout (4, 1));
    ProfilePanel.add (ProfileNone);
    ProfilePanel.add (ProfileDef);
    ProfilePanel.add (ProfileHere);
    ProfilePanel.add (UserProfile);
    UserProfile.setEnabled   (false);
    UserProfile.setEditable  (false);

    ProfileHere.addItemListener (this);
    ProfileDef .addItemListener (this);
    ProfileNone.addItemListener (this);


    ChecksPanel.setLayout (new BorderLayout(3, 3));
    ChecksPanel.setInner  (BPanel.NONE);
    ChecksPanel.setOuter  (BPanel.NONE);
    ChecksPanel.add (VerifyPanel,  BorderLayout.NORTH);
    ChecksPanel.add (ProfilePanel, BorderLayout.CENTER);
    ChecksPanel.add (EditMemorySizesButton, BorderLayout.SOUTH);
    EditMemorySizesButton.addActionListener (this);

    OptionsPanel.setLayout (new BorderLayout());
    OptionsPanel.add (MainPanel,    BorderLayout.WEST);
    OptionsPanel.add (ChecksPanel,  BorderLayout.EAST);

    setLayout (new BorderLayout());
    add (OptionsPanel, BorderLayout.NORTH);
    getOptions();
  }

  public String toString () {
    return "Debugger";
  }

  public void setMainPanel () {
    MainPanel.removeAll();
    int PrefWidth = FlagsPanel.getPreferredSize().width;
    PathsOptionsConfig.getDefaultRunnablePanel().setPreferredSize(new Dimension(PrefWidth, -1));
    CommandLinePanel.setPreferredSize(new Dimension(PrefWidth, -1));
    JPanel MiscPanel = new JPanel();
    MiscPanel.setLayout (new BorderLayout());
    MiscPanel.add (PathsOptionsConfig.getDefaultRunnablePanel(), BorderLayout.NORTH);
    MiscPanel.add (PathsOptionsConfig.getDefaultRunnableHTMLPanel(), BorderLayout.CENTER);
    MiscPanel.add (CommandLinePanel,     BorderLayout.SOUTH);

    MainPanel.add (MiscPanel,            BorderLayout.NORTH);
    MainPanel.add (FlagsPanel,           BorderLayout.SOUTH);
  }

  public void initGUI () {
    setMainPanel();
  }

  public Component getGUI () {
    return this;
  }

  public void itemStateChanged (ItemEvent e) {
    if (e.getSource().equals (ProfileHere)) {
      UserProfile.setEnabled  (true);
      UserProfile.setEditable (true);
    }
    if (e.getSource().equals (ProfileNone)) {
      UserProfile.setEnabled  (false);
      UserProfile.setEditable (false);
    }
    if (e.getSource().equals (ProfileDef)) {
      UserProfile.setEnabled  (false);
      UserProfile.setEditable (false);
    }

  }

  private void setMemSizes (MemorySizesDialog MemSizes) {
    MemSizes.setNativeStack(NativeStack);
    MemSizes.setJavaStack  (JavaStack);
    MemSizes.setInitialHeap(InitialHeap);
    MemSizes.setJavaHeap   (JavaHeap);

    MemSizes.setDefaultNativeStack(DefNativeStack);
    MemSizes.setDefaultJavaStack  (DefJavaStack);
    MemSizes.setDefaultInitialHeap(DefInitialHeap);
    MemSizes.setDefaultJavaHeap   (DefJavaHeap);
  }

  private void getMemSizes (MemorySizesDialog MemSizes) {
    NativeStack = MemSizes.getNativeStack();
    JavaStack   = MemSizes.getJavaStack();
    InitialHeap = MemSizes.getInitialHeap();
    JavaHeap    = MemSizes.getJavaHeap();

    DefNativeStack = MemSizes.isDefaultNativeStack();
    DefJavaStack   = MemSizes.isDefaultJavaStack  ();
    DefInitialHeap = MemSizes.isDefaultInitialHeap();
    DefJavaHeap    = MemSizes.isDefaultJavaHeap   ();
  }

  public void actionPerformed (ActionEvent e) {
    MemorySizesDialog MemSizes = new MemorySizesDialog ();
    setMemSizes (MemSizes);
    MemSizes.setVisible(true);
    if (MemSizes.isConfirmed())
      getMemSizes (MemSizes);
    MemSizes.dispose();  
  }

  public void getOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    VMOptions NewOptions = (VMOptions)(AOptions.getOptions(VMOptions.VMOptionsName));

    switch (NewOptions.getProfileFlags()) {
      case VMOptions.PROFILE_NONE:
        ProfileNone.setSelected(true);
      break;
      case VMOptions.PROFILE_DEF:
        ProfileDef .setSelected(true);
      break;
      case VMOptions.PROFILE_HERE:
        ProfileHere.setSelected(true);
      break;
    }

    switch (NewOptions.getVerifyFlags()) {
      case VMOptions.VERIFY_ALL:
        VerifyAll.setSelected(true);
      break;
      case VMOptions.VERIFY_REMOTE:
        VerifyRemote.setSelected(true);
      break;
      case VMOptions.VERIFY_NONE:
        VerifyNone.setSelected(true);
      break;
    }

    UserProfile.setText(NewOptions.getUserProfile());

    Verbose   .setSelected (NewOptions.isVerbose());
    Debug     .setSelected (NewOptions.isDebug());
    NoAsync   .setSelected (NewOptions.isNoAsync());
    VerboseGC .setSelected (NewOptions.isVerboseGC());
    NoClassGC .setSelected (NewOptions.isNoClassGC());

    Params     .setText (NewOptions.getParams());

    NativeStack = NewOptions.getNativeStack();
    JavaStack   = NewOptions.getJavaStack();
    InitialHeap = NewOptions.getInitialHeap();
    JavaHeap    = NewOptions.getJavaHeap();

    DefNativeStack = NewOptions.isDefaultNativeStack();
    DefJavaStack   = NewOptions.isDefaultJavaStack();
    DefInitialHeap = NewOptions.isDefaultInitialHeap();
    DefJavaHeap    = NewOptions.isDefaultJavaHeap();
  }

  public void setOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    VMOptions NewOptions = (VMOptions) (AOptions.getOptions(VMOptions.VMOptionsName));

    if (ProfileNone.isSelected())
      NewOptions.setProfileFlags(VMOptions.PROFILE_NONE);
    if (ProfileDef .isSelected())
      NewOptions.setProfileFlags(VMOptions.PROFILE_DEF);
    if (ProfileNone .isSelected())
      NewOptions.setProfileFlags(VMOptions.PROFILE_NONE);

    if (VerifyAll   .isSelected())
      NewOptions.setVerifyFlags(VMOptions.VERIFY_ALL);
    if (VerifyRemote.isSelected())
      NewOptions.setVerifyFlags(VMOptions.VERIFY_REMOTE);
    if (VerifyNone.isSelected())
      NewOptions.setVerifyFlags(VMOptions.VERIFY_NONE);

    NewOptions.setUserProfile(UserProfile.getText());

    NewOptions.setVerbose   (Verbose  .isSelected ());
    NewOptions.setDebug     (Debug    .isSelected ());
    NewOptions.setNoAsync   (NoAsync  .isSelected ());
    NewOptions.setVerboseGC (VerboseGC.isSelected ());
    NewOptions.setNoClassGC (NoClassGC.isSelected ());

    NewOptions.setDefaultNativeStack(DefNativeStack);
    NewOptions.setDefaultJavaStack  (DefJavaStack);
    NewOptions.setDefaultInitialHeap(DefInitialHeap);
    NewOptions.setDefaultJavaHeap   (DefJavaHeap);

    NewOptions.setParams  (Params .getText ());

    NewOptions  .setNativeStack (NativeStack);
    NewOptions  .setJavaStack   (JavaStack);
    NewOptions  .setInitialHeap (InitialHeap);
    NewOptions  .setJavaHeap    (JavaHeap);
    AOptions.setOptions (NewOptions);
  }
}

