/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.config;
import java.awt.*;
import java.awt.event.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class ConfirmCloseAllDialog extends Dialog implements ActionListener {
  private BPanel ButtonsPanel = new BPanel();
  private BPanel MessagePanel = new BPanel("Modified Files");
  private BPanel MainPanel    = new BPanel();

  private static final String SELECT_ALL_CMD  = "Select All";
  private static final String SELECT_NONE_CMD = "Select None";
  private static final String OK_CMD          = "OK";
  private static final String CANCEL_CMD      = "Cancel";

  private Button SelectNoneButton = new Button (SELECT_ALL_CMD);
  private Button SelectAllButton  = new Button (SELECT_NONE_CMD);
  private Button OKButton         = new Button (OK_CMD);
  private Button CancelButton     = new Button (CANCEL_CMD);

  private Checkbox [] Checkboxes;
  private boolean Confirmed;
  private StringList ModifiedFiles;

  public ConfirmCloseAllDialog (StringList ModifiedFiles){
    super (Globals.IdeMainFrame);
    this.ModifiedFiles = ModifiedFiles;
    ButtonsPanel.setLayout (new GridLayout (1, 4, 5, 5));
    ButtonsPanel.add (OKButton);
    ButtonsPanel.add (CancelButton);
    ButtonsPanel.add (SelectAllButton);
    ButtonsPanel.add (SelectNoneButton);

    OKButton        .addActionListener (this);
    CancelButton    .addActionListener (this);
    SelectAllButton .addActionListener (this);
    SelectNoneButton.addActionListener (this);

    initMessagePanel ();

    MainPanel.setLayout (new BorderLayout(10, 10));
    MainPanel.setInner (BPanel.NONE);
    MainPanel.setOuter (BPanel.NONE);
    MainPanel.setBorderWidth (5);

    MainPanel.add (ButtonsPanel, BorderLayout.SOUTH);
    MainPanel.add (MessagePanel, BorderLayout.NORTH);

    setLayout (new BorderLayout());
    setModal (true);
    setTitle ("Select Files to Save");
    add (MainPanel, BorderLayout.CENTER);
    setSize (getToolkit().getScreenSize());
    pack();
    setResizable    (true);
    Misc.hardCenter (this);
  }

  private void initMessagePanel () {
    int Len = ModifiedFiles.getCount();
    int i;
    MessagePanel.setLayout (new GridLayout(Len, 1));
    Checkboxes = new Checkbox [Len];
    for (i = 0; i < Len; i++) {
      Checkboxes [i] = new Checkbox (ModifiedFiles.getString (i), true);
      MessagePanel.add (Checkboxes [i]);
    }
  }

  public boolean isConfirmed () {
    return Confirmed;
  }

  public StringList getSelectedFiles () {
    StringList SelectedFiles = new StringList();
    int i;

    for (i = 0; i < Checkboxes.length; i++)
      if (Checkboxes [i].getState ())
        SelectedFiles.Add (ModifiedFiles.getString(i), ModifiedFiles.getObject(i));
    return SelectedFiles;
  }

  public void actionPerformed (ActionEvent e) {
    String CMD = e.getActionCommand();
    int i;

    if (CMD.compareTo (CANCEL_CMD) == 0) {
      Confirmed = false;
      setVisible (false);
      dispose();
    }

    if (CMD.compareTo (SELECT_ALL_CMD) == 0) {
      for (i = 0; i < Checkboxes.length; i++)
        Checkboxes [i].setState (true);
    }

    if (CMD.compareTo (SELECT_NONE_CMD) == 0) {
      for (i = 0; i < Checkboxes.length; i++)
        Checkboxes [i].setState (false);
    }

    if (CMD.compareTo (OK_CMD) == 0) {
      Confirmed = true;
      setVisible (false);
      dispose();
    }
  }
}
