/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options;

import java.util.EventObject;
import org.freebuilder.system.classes.events.engine.*;

/** The <code>OptionsEventAdapter</code> will accept all the events of class OptionsEvent
  * These events are sended when Options for some tool or IDE have been changed.
  * All objects which are related with this have to use, this Adapter to be notified, when
  * this happened.
  * These events will be dispatched via the name of the * Options first (Options.getName()),
  * and then comparing the number of the event.
  * IF name of the options is empty String, or event if there is not an Options object,
  * means that this is a Broadcast message to listeners which Handle the events of that class,
  * and every listener will compare the number of the event to see if have to handle.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */
  
public class OptionsEventAdapter extends NumberAdapter {
  String       OptionsName;

  public OptionsEventAdapter(String OptionsName, int AEventNumber, int ACallMask,  Object AMethodRef, String AMethodName)
    throws NoSuchMethodException, SecurityException {
    super(AEventNumber, ACallMask,  AMethodRef, AMethodName);
    this.OptionsName = OptionsName;
  }

  public OptionsEventAdapter(String OptionsName, int AEventNumber, Object AMethodRef, String AMethodName)
    throws NoSuchMethodException, SecurityException {
    this(OptionsName, AEventNumber, IdeEventListenerI.CALL_MASK,  AMethodRef, AMethodName);
  }

  protected Class PrepareEventsClass() {
    OptionsEvent Event = new OptionsEvent(0, new EventObject(this), null);
    return Event.getClass();
  }

  /** Function <code>AcceptEvent</code> compares first the name of the options. The one of
    * the event, and the other for listener. IF they are equal than number compare is performed,
    * like in Number event. IF the name for options in listener (this) in the event is null, or
    * is an empty string than it assumed that this is a broadcast command to all the listeners
    * for options.
    */
  public boolean AcceptEvent(IdeSuperEvent AEvent) {
    if (AEvent == null) return false;

    OptionsEvent  Event       = (OptionsEvent)AEvent;
    OptionsSuperI Options     = null;
    String        OptionsName = "";

    if (Event != null) {
      Options = Event.getOptions();
      if (Options != null) {
        OptionsName = Options.getName();  // Get the name of the options
        if (OptionsName.length() != 0) {
          if (OptionsName.compareTo(this.OptionsName) != 0)
            return false;
        }
      }
    }
    return ((NumberEvent)AEvent).EventID == getEventNumber();
  }
}
