/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.gui.idemenu;

import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import org.freebuilder.system.classes.events.engine.IdeEventsEngine;
import org.freebuilder.system.classes.events.engine.*;
import org.freebuilder.system.classes.events.*;
import org.freebuilder.system.ideengine.*;

/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
public class QueryEnDisMenuItem extends IdeMenuItem {
  private int QueryCommand;

  public QueryEnDisMenuItem (int CmndNumber, int QueryCommand) {
    super (CmndNumber);
    init(QueryCommand);
  }

  public QueryEnDisMenuItem (int CmndNumber, int QueryCommand, String label) {
    super(CmndNumber, label);
    init(QueryCommand);
  }

  public QueryEnDisMenuItem (int CmndNumber, int QueryCommand, String label, MenuShortcut s) {
    super (CmndNumber, label, s);
    init(QueryCommand);
  }

  private void init (int QueryCommand) {
    this.QueryCommand = QueryCommand;
    setCheckStatusListener (this);
  }

  public boolean HaveToEnableMenuItem (IdeMenuItem menuItem) {
    SystemEvent SEvent = new SystemEvent (QueryCommand, this);
    Globals.EventsEngine.SendEvent (SEvent);
    return (SEvent.Result == 1) && (super.HaveToEnableMenuItem(this));
  }
}
