/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */
package org.freebuilder.gui.config;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import com.sun.java.swing.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ideoptions.*;
import org.freebuilder.system.ideengine.*;
import org.freebuilder.system.classes.options.manager.*;
/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
class EditorOptionsPanel extends BPanel implements Configurator {

  private JPanel NorthPanel           = new JPanel();
  private JComboBox FontComboBox      = new JComboBox();
  private JComboBox StyleComboBox     = new JComboBox();
  private JComboBox SizeComboBox      = new JComboBox();
  private JComboBox BGComboBox        = new JComboBox();
  private JComboBox FGComboBox        = new JComboBox();
  private JLabel FontLabel            = new JLabel("Font:");
  private JLabel StyleLabel           = new JLabel("Style:");
  private JLabel SizeLabel            = new JLabel("Size:");
  private JLabel BGLabel              = new JLabel("Background Color");
  private JLabel FGLabel              = new JLabel("Text Color:");

  public EditorOptionsPanel () {
    super ("Editor Options:");

    FontComboBox.setEditable(false);
    String[] fontNames = getToolkit().getFontList();
    for (int i = 0; i < fontNames.length; i++)
      {
	      FontComboBox.addItem(fontNames[i]);
      }

    StyleComboBox.setEditable(false);
    StyleComboBox.addItem("Plain");
    StyleComboBox.addItem("Bold");
    StyleComboBox.addItem("Italic");
    StyleComboBox.addItem("Bold+Italic");

    SizeComboBox.setEditable(false);
    SizeComboBox.addItem("8");
    SizeComboBox.addItem("9");
    SizeComboBox.addItem("10");
    SizeComboBox.addItem("11");
    SizeComboBox.addItem("12");
    SizeComboBox.addItem("14");
    SizeComboBox.addItem("16");
    SizeComboBox.addItem("18");
    SizeComboBox.addItem("24");
    SizeComboBox.addItem("36");
    SizeComboBox.addItem("48");

    FGComboBox.setEditable(false);
    FGComboBox.addItem("Black");
    FGComboBox.addItem("Blue");
    FGComboBox.addItem("Cyan");
    FGComboBox.addItem("Dark Gray");
    FGComboBox.addItem("Gray");
    FGComboBox.addItem("Green");
    FGComboBox.addItem("Light Gray");
    FGComboBox.addItem("Magenta");
    FGComboBox.addItem("Orange");
    FGComboBox.addItem("Pink");
    FGComboBox.addItem("Red");
    FGComboBox.addItem("Yellow");
    FGComboBox.addItem("White");

    BGComboBox.setEditable(false);
    BGComboBox.addItem("Black");
    BGComboBox.addItem("Blue");
    BGComboBox.addItem("Cyan");
    BGComboBox.addItem("Dark Gray");
    BGComboBox.addItem("Gray");
    BGComboBox.addItem("Green");
    BGComboBox.addItem("Light Gray");
    BGComboBox.addItem("Magenta");
    BGComboBox.addItem("Orange");
    BGComboBox.addItem("Pink");
    BGComboBox.addItem("Red");
    BGComboBox.addItem("Yellow");
    BGComboBox.addItem("White");

    NorthPanel.setLayout (new GridLayout(5,2,7,7));
    NorthPanel.add (FontLabel);
    NorthPanel.add (FontComboBox);
    NorthPanel.add (StyleLabel);
    NorthPanel.add (StyleComboBox);
    NorthPanel.add (SizeLabel);
    NorthPanel.add (SizeComboBox);
    NorthPanel.add (FGLabel);
    NorthPanel.add (FGComboBox);
    NorthPanel.add (BGLabel);
    NorthPanel.add (BGComboBox);

    setLayout (new BorderLayout(7,7));
    add (NorthPanel,BorderLayout.NORTH);

    getOptions();
  }

  public String toString () {
    return "Editor";
  }

  private Color getColorFromString(String ColorName) {
    if (ColorName == "Black")
      return Color.black;
    if (ColorName == "Blue")
      return Color.blue;
    if (ColorName == "Cyan")
      return Color.cyan;
    if (ColorName == "Dark Gray")
      return Color.darkGray;
    if (ColorName == "Gray")
      return Color.gray;
    if (ColorName == "Green")
      return Color.green;
    if (ColorName == "Light Gray")
      return Color.lightGray;
    if (ColorName == "Magenta")
      return Color.magenta;
    if (ColorName == "Orange")
      return Color.orange;
    if (ColorName == "Pink")
      return Color.pink;
    if (ColorName == "Red")
      return Color.red;
    if (ColorName == "White")
      return Color.white;
    if (ColorName == "Yellow")
      return Color.yellow;
    return Color.black;
  }

  private String getStringFromColor(Color TheColor) {
    if (TheColor.equals(Color.black))
      return "Black";
    if (TheColor.equals(Color.blue))
      return "Blue";
    if (TheColor.equals(Color.cyan))
      return "Cyan";
    if (TheColor.equals(Color.darkGray))
      return "Dark Gray";
    if (TheColor.equals(Color.gray))
      return "Gray";
    if (TheColor.equals(Color.green))
      return "Green";
    if (TheColor.equals(Color.lightGray))
      return "Light Gray";
    if (TheColor.equals(Color.magenta))
      return "Magenta";
    if (TheColor.equals(Color.orange))
      return "Orange";
    if (TheColor.equals(Color.pink))
      return "Pink";
    if (TheColor.equals(Color.red))
      return "Red";
    if (TheColor.equals(Color.white))
      return "White";
    if (TheColor.equals(Color.yellow))
      return "Yellow";
    return "Black";
  }

  public void getOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    EditorOptions   NewOptions     = (EditorOptions) (AOptions.getOptions(EditorOptions.EditorOptionsName));

    FontComboBox.setSelectedItem(NewOptions.getFontName());
    
    switch (NewOptions.getFontStyle()) {
    case Font.PLAIN:    
      StyleComboBox.setSelectedItem("Plain");
      break;
    case Font.BOLD:    
      StyleComboBox.setSelectedItem("Bold");
      break;
    case Font.ITALIC:    
      StyleComboBox.setSelectedItem("Italic");
      break;
    case (Font.BOLD + Font.ITALIC):    
      StyleComboBox.setSelectedItem("Bold+Italic");
      break;
    }        
    SizeComboBox.setSelectedItem(Integer.toString(NewOptions.getFontSize()));
    
    FGComboBox.setSelectedItem(getStringFromColor(NewOptions.getFGColor()));
    BGComboBox.setSelectedItem(getStringFromColor(NewOptions.getBGColor()));
  }

  public Component getGUI () {
    return this;
  }
  
  public void initGUI () { }

  private int getFontStyle () {
    String TheStyle = (String)StyleComboBox.getSelectedItem();
    if (TheStyle == "Plain")
      return Font.PLAIN;
    if (TheStyle == "Bold")
      return Font.BOLD;
    if (TheStyle == "Italic")
      return Font.ITALIC;
    if (TheStyle == "Bold+Italic")
      return Font.BOLD + Font.ITALIC;
    return 0;
  }
  
  public void setOptions () {
    OptionsMngr AOptions = Globals.IEngine.getOptions();
    EditorOptions   NewOptions     = (EditorOptions) (AOptions.getOptions(EditorOptions.EditorOptionsName));

    NewOptions.setFontName   ((String)FontComboBox.getSelectedItem());
    NewOptions.setFontStyle  (getFontStyle());
    NewOptions.setFontSize   (new Integer((String)SizeComboBox.getSelectedItem()).intValue());
    NewOptions.setFGColor    (getColorFromString((String)FGComboBox.getSelectedItem()));
    NewOptions.setBGColor    (getColorFromString((String)BGComboBox.getSelectedItem()));

    AOptions.setOptions (NewOptions);
  }
}

