/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.tools.editor;

import org.freebuilder.gui.beans.*;
import org.freebuilder.gui.ide.*;
import org.freebuilder.gui.idemenu.*;
import org.freebuilder.system.ideengine.*;
import java.awt.*;
import java.awt.event.*;

import com.sun.java.swing.*;
import com.sun.java.swing.text.*;


/**
  * @author	<a href=mailto:wreck@nat.bg> Peter Radkov </a>
    @version 0.7, 07-01-98
*/
/** This class keeps track of the selection, ensuring the Cut, Copy,...  etc.
    buttons are always ap to date.
*/
class MyHighlighter extends DefaultHighlighter {
  private boolean IsThereReallySomthingSelected = false;

  public Object addHighlight (int Start, int End, Highlighter.HighlightPainter ThePainter) throws BadLocationException {
    Object Ret = super.addHighlight (Start, End, ThePainter);
    int SelectionLength = End - Start;
    if (IsThereReallySomthingSelected) {
      if (SelectionLength == 0) {
        IsThereReallySomthingSelected = false;
        updateMenus();
      }
    } else {
      if (SelectionLength > 0) {
        IsThereReallySomthingSelected = true;
        updateMenus();
      }
    }
    return Ret;
  }

  public void updateMenus () {
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditCut,   MainMenuEvent.msubcRefresh, this));
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditCopy,  MainMenuEvent.msubcRefresh, this));
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditPaste, MainMenuEvent.msubcRefresh, this));
    Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditDelete,MainMenuEvent.msubcRefresh, this));
  }

  public void changeHighlight (Object tag, int Start, int End) throws BadLocationException {
    int SelectionLength = End - Start;
    if (IsThereReallySomthingSelected) {
      if (SelectionLength == 0) {
        IsThereReallySomthingSelected = false;
        updateMenus ();
      }
    } else {
      if (SelectionLength > 0) {
        IsThereReallySomthingSelected = true;
        updateMenus ();
      }
    }
    super.changeHighlight (tag, Start, End);
  }

  public void removeHighlight (Object tag)  {
    updateMenus ();
    IsThereReallySomthingSelected = false;
    super.removeHighlight (tag);
  }
}
/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
/** This class is the panel, that encapsulates the text editor and the text editing speed buttons. */
public class Editor extends BPanel implements SpeedListener {
  private SourceTextArea TheSourceArea;
  public static final String EditorName = "Source Editor";
  private SJPanel SpeedPanel = new SJPanel();
  private MenuSpeedButton CutButton    = new MenuSpeedButton (IdeMainMenu.msgmiEditCut,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Cut.gif"),0);
  private MenuSpeedButton CopyButton   = new MenuSpeedButton (IdeMainMenu.msgmiEditCopy,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Copy.gif"),1);
  private MenuSpeedButton PasteButton  = new MenuSpeedButton (IdeMainMenu.msgmiEditPaste,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Paste.gif"),2);
  private MenuSpeedButton DeleteButton = new MenuSpeedButton (IdeMainMenu.msgmiEditDelete,
                                             Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Delete.gif"),3);

  private int SpeedButtonsSize         = 24;

  public Editor () {
    super(EditorName);
    setLayout (new BorderLayout());
    initSpeedPanel ();
  }

  public void actionPerformed (ActionEvent e) {
    Globals.IEngine.clearOutput();
  }
  public void speedEntered (SpeedButton AButton) {}
  public void speedExited (SpeedButton AButton) {}

  public void initSpeedPanel () {
    SpeedButton Clear = new SpeedButton (Globals.ResourceMngr.loadImage (Globals.spbIconsDir + "Delete.gif"), 0, 3);
    Clear.canBePressed (false);
    Clear.setHint      ("Clear Output");
    Clear.addActionListener (this);
    Clear.setSize      (SpeedButtonsSize, SpeedButtonsSize);

    SpeedPanel.setLayout (new BorderLayout ());
    JPanel LeftSpeedPanel = new JPanel();
    LeftSpeedPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 1, 1));
    IdeMenuItem AMenuItem;

    CutButton   .setSize (SpeedButtonsSize, SpeedButtonsSize);
    CopyButton  .setSize (SpeedButtonsSize, SpeedButtonsSize);
    PasteButton .setSize (SpeedButtonsSize, SpeedButtonsSize);
    DeleteButton.setSize (SpeedButtonsSize, SpeedButtonsSize);

    CutButton   .canBePressed (false);
    CopyButton  .canBePressed (false);
    PasteButton .canBePressed (false);
    DeleteButton.canBePressed (false);

    CutButton   .setHint ("Cut");
    CopyButton  .setHint ("Copy");
    PasteButton .setHint ("Paste");
    DeleteButton.setHint ("Delete");

    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu (IdeMainMenu.msgmiEditCut);
    AMenuItem.setSpeedButton (CutButton);
    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu (IdeMainMenu.msgmiEditCopy);
    AMenuItem.setSpeedButton (CopyButton);
    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu (IdeMainMenu.msgmiEditPaste);
    AMenuItem.setSpeedButton (PasteButton);
    AMenuItem = (IdeMenuItem) Globals.MainMenu.FindMenu (IdeMainMenu.msgmiEditDelete);
    AMenuItem.setSpeedButton (DeleteButton);

    LeftSpeedPanel.add (CutButton);
    LeftSpeedPanel.add (CopyButton);
    LeftSpeedPanel.add (PasteButton);
    LeftSpeedPanel.add (DeleteButton);

    SpeedPanel.add (LeftSpeedPanel, BorderLayout.WEST);
    SpeedPanel.add (Clear, BorderLayout.EAST);

    add (SpeedPanel, BorderLayout.NORTH);
  }

  public SourceTextArea getSourceArea () {
    return TheSourceArea;
  }

  /** Sets the active file to edit or view. */
  public void setActiveEditFile (EditFile TheFile) {
    if (TheSourceArea != null) {
      remove (TheSourceArea);
      Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditCut,   MainMenuEvent.msubcRefresh, this));
      Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditCopy,  MainMenuEvent.msubcRefresh, this));
      Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditPaste, MainMenuEvent.msubcRefresh, this));
      Globals.EventsEngine.PostEvent (new MainMenuEvent (IdeMainMenu.msgmiEditDelete,MainMenuEvent.msubcRefresh, this));
    }

    if (TheFile != null) {
      TheSourceArea = TheFile.getSourceArea();
      if (!(TheSourceArea.getTextArea().getHighlighter() instanceof MyHighlighter))
        TheSourceArea.getTextArea().setHighlighter (new MyHighlighter());
      ((MyHighlighter)TheSourceArea.getTextArea().getHighlighter()).updateMenus();
      add (TheSourceArea, BorderLayout.CENTER);
      setTitle (EditorName + " : " + TheFile.getFullDosPath());
      invalidate();
      validate();
    } else {
      TheSourceArea = null;
      setTitle (EditorName);
    }
  }
}
