/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;
import org.freebuilder.gui.beans.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.ideengine.Globals;
import java.io.*;
import java.util.zip.*;

/**
   @author	Peter Radkov <wreck@nat.bg>
   @version 0.7, 07-01-98
*/
class ZipParser {
  private String    NodeName = null;
  private ZipParser Parent   = null;
  private Vector    Children = null;
  private int       Depth    = 0;
  public static ZipFile             TheZipFile = null;
  public static PZipDirectoryEntry  Root       = null;

  public ZipParser (ZipParser Parent, String NodeName, int Depth) {
    this.Parent   = Parent;
    this.NodeName = NodeName;
    this.Depth    = Depth;
  }

  private void forseAddNode (String[] ZipEntryParsedName) {
    ZipParser NewParser = new ZipParser (this, ZipEntryParsedName[Depth+1], Depth+1);
    Children.addElement (NewParser);
    if (Depth+2 < ZipEntryParsedName.length)
      NewParser.addNode (ZipEntryParsedName);
  }

  public void addNode (String ZipEntryName) {
    String [] ToAdd = Misc.parsePath(ZipEntryName, '/');
    addNode (ToAdd);
  }

  public void addNode (String[] ZipEntryParsedName) {
    if (Children == null) {
      Children = new Vector();
      forseAddNode (ZipEntryParsedName);
      return;
    }
    int i;
    int Count = Children.size();
    for (i = 0; i < Count; i++) {
      ZipParser CurrentChild = (ZipParser) Children.elementAt(i);
      if ((CurrentChild.getName().compareTo(ZipEntryParsedName[Depth+1]) == 0) &&
          (ZipEntryParsedName.length-1 > Depth+1)) {
        CurrentChild.addNode (ZipEntryParsedName);
        return;
      }
    }
    forseAddNode (ZipEntryParsedName);
  }

  public String getName () {
    return NodeName;
  }

  public String getFullEntryName () {
    if (NodeName == null)
      return "";
    String Ret = Parent.getFullEntryName() + NodeName;
    if (Children == null)
      return Ret;
    return Ret + "/";
  }

  public void fillItems (PZipDirectoryEntry Parent) {
    if (Children == null) {
      ZipEntry ThisEntry =  TheZipFile.getEntry (getFullEntryName());
      Parent.addPacketItem (new PZipFileEntry (ThisEntry, getName(), Parent, Root));
      return;
    }
    PZipDirectoryEntry ThisDir;
    if (getName() == null)
      ThisDir = Parent;
    else {
      ThisDir = new PZipDirectoryEntry (getName(), Parent, Root);
      Parent.addPacketItem (ThisDir);
    }  
    int Count = Children.size();
    for (int i = 0; i < Count; i++)
      ((ZipParser) Children.elementAt(i)).fillItems (ThisDir);
  }
}

