/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.packages;

import java.util.*;
import org.freebuilder.system.classes.*;
import org.freebuilder.system.ideengine.Globals;
import java.io.File;

/** <code>PDirectory</code> is for organizing hirerachically of directories
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 12/12/97
*/

public class PDirectory extends PDirectoryEntry {
  private boolean isBrowsed = false;

  public PDirectory(File AFile, PacketItemI AParentItem, PacketItemI ARootItem) {
    super(AFile, AParentItem, ARootItem);
  }

  public int     getPacketItemKind() {
    return PacketItemI.cpikDirectory;
  }

  protected int setPacketItemKind() {
    ItemKind = PacketItemI.cpikDirectory;
    return ItemKind;
  }

  public int getPacketItemsCount() {
    String DirName = getFullDosPath();
    
    if (! isBrowsed) {
      RefreshItems();
      isBrowsed = true;
    }
    return justGetCount();
  }
  
  /** adds the file first */
  private int addFileItem(PacketItemI APacketItem) {
    if (APacketItem == null) return -1;
    String AFileName = APacketItem.getFileName();
    Insert(0, AFileName, APacketItem);
    return 0;
  }

  protected PacketItemI CreateDirEntry(File AFile, PacketItemI AParentItem, PacketItemI ARootItem) {
    PacketItemI Result = new PDirectory(AFile, AParentItem, ARootItem);
    return Result;
  }
}
