/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.options.manager;

import java.lang.*;
import org.freebuilder.system.debug.*;
import org.freebuilder.system.classes.options.*;
import org.freebuilder.system.classes.options.opened.*;
import org.freebuilder.system.classes.events.engine.IdeEventsEngine;

/** <code>ProjectConfig</code> represents the configuration for some project
  * If have also support a collections of the latest opened files and latest browsed files.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

public class ProjectConfig extends DefaultOptions {
  public final static String cRecentFilesOName = "Reopen Files";

  public ProjectConfig(IdeEventsEngine AEventsEngine, String AConfigFileName, CreateDOptionsListener DOptionsCreateObject) {
    super(AEventsEngine, AConfigFileName, DOptionsCreateObject);
  }

  protected String getOFilesOptionsName() { return cRecentFilesOName; };

  public void CreateDefaultConfig() {
    StrItems LastOpenedFiles = null;
    super.CreateDefaultConfig();
    LastOpenedFiles = new StrItems(getOFilesOptionsName());
    try {
// Altered by P.R. Was this:
//      addOptions(getLastOpenedFiles() /* LastOpenedFiles*/);
     addOptions(LastOpenedFiles);
    }
    catch (DuplicateOptionNameException e) {
      Debug.Assert(e,this," in MainConfig.CreateDefaultConfig ");
    };
  }

  /** Returns a StrItems collection of last opened files */
  public StrItems getLastOpenedFiles() {
    return (StrItems)getOptions(getOFilesOptionsName());
  }

  /** Add AFileName to the collection of last opened files at first place */
  public void OpenFile   (String AFileName) {
    StrItems LastOpenedFiles = getLastOpenedFiles(); if (LastOpenedFiles  == null) return;
    LastOpenedFiles.OnOpenFile(AFileName);
    setOptions(LastOpenedFiles);
  }

  public void CloseFile  (String AFileName) {
    StrItems LastOpenedFiles = getLastOpenedFiles(); if (LastOpenedFiles  == null) return;
    LastOpenedFiles.OnCloseFile();
    setOptions(LastOpenedFiles);
  }

  /** for test only */
  public void PrintOptions() {
    StrItems LastOpenedFiles = getLastOpenedFiles(); if (LastOpenedFiles  == null) return;
    super.PrintOptions();

    if (LastOpenedFiles  != null) {
      System.out.println("");
      System.out.println("Last Opened Files ");
      LastOpenedFiles.PrintItems();
    }
  }
}
