/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events.engine;

/** The class <code>IdeEventsListItem</code>
  * creates a dual linked list of EventListeners it also calls apropriate method for it's EventListener.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

/** for creating a dual linked list of EventListeners it also calls apropriate method for it's EventListener. */
class IdeEventsListItem { // only in this package
  IdeEventsListItem   nextListItem; // link to the next event listener (if any), or null
  IdeEventsListItem   prevListItem; // link to the previous event listener (if any), or null
  IdeEventListenerI   TheListener;  // our goal.

  IdeEventsListItem() {
    this(null);
  }

  IdeEventsListItem(IdeEventListenerI AListener) {
    nextListItem = null;
    prevListItem = null;
    TheListener  = AListener;
  }

  IdeEventsListItem getNext() { return nextListItem; }
  IdeEventsListItem getPrev() { return prevListItem; }

  private void SetHandledEvent(IdeSuperEvent TheEvent) {
    if (TheEvent != null) TheEvent.SetHandled();
  }

  /** true - attached listener will also handle derivated events from TheListener.getEventsClass() */
  boolean isChildEventsListener() {
    if (TheListener == null) return false;
    return TheListener.isChildEventsListener();
  }

  /** Puts this IdeEventsListItem before NewItem.
    * this method shall be called only from synchronized function */
  void PutBefore(IdeEventsListItem NewItem) {
    if (NewItem == null) return;

    nextListItem         = NewItem;
    prevListItem         = NewItem.prevListItem;
    NewItem.prevListItem = this;
  }

  /** remove this list item from the chain
    * this method shall be called only from synchronized function */
  void Remove() {
    if (TheListener != null)
      TheListener.setIdeEventLEnable(false);

    if (prevListItem != null)
      prevListItem.nextListItem = nextListItem;

    if (nextListItem  != null)
      nextListItem.prevListItem = prevListItem;
  }

  /** regarding of WhichOne calls attached listener BeforeAction, OnAction or AfterAction
    * Only the first matching method will be called */
  void DispatchEvent(IdeSuperEvent TheEvent, int WhichOne, boolean JustCheck) {
    if (TheListener == null) return;

    if (! TheListener.AcceptEvent(TheEvent)) return;

    if (WhichOne <= IdeEventsEngine.CALL_BEFORE_METHOD) {
      if (TheListener.ShallCallBefore()) {
        if ((! JustCheck) && TheListener.isIdeEventLEnabled())
          TheListener.BeforeAction(TheEvent);

        SetHandledEvent(TheEvent);
      }
      return;
    }

    if (WhichOne == IdeEventsEngine.CALL_DO_METHOD) {
      if (TheListener.ShallCall()) {
        if ((! JustCheck) && TheListener.isIdeEventLEnabled())
          TheListener.OnAction(TheEvent);
        SetHandledEvent(TheEvent);
      }
      return;
    }

    if (TheListener.ShallCallAfter()) {
      if ((! JustCheck) && TheListener.isIdeEventLEnabled())
        TheListener.AfterAction(TheEvent);
      SetHandledEvent(TheEvent);
    }
  }
}


