/*
 * Copyright (c) 1998 Vanand Ltd.
 * <vanand@mail.techno-link.com>, <vanand@iname.com>, <a-hristov@usa.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * If you modify this file, please send us a copy.
 */

package org.freebuilder.system.classes.events;

import java.util.EventObject;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import org.freebuilder.system.classes.events.engine.*;

// All Events dispatching through number should derive from this object, and override PrepareEvent method

/** This class is useful when we want to send a Event on some ActionPerformed.
  * For example when some button is pressed want to receive a global event via EventsEngine
  * can add subclass of this to button. buttol.addActionListener(<code>MenuEventAdapter</code>)
  * Descendent class have to override PrepareEvent method.
  *
  * @author	George Petkov <a href=mailto:pgeorge@mail.techno-link.com> pgeorge@mail.techno-link.com </a>,  <a href=mailto:gpetkov@usa.net> gpetkov@usa.net</a>
  * @version 0.7, 02-12-97 */

abstract public class NActionAdapter implements ActionListener {
  IdeEventsEngine EventsEngine;
  int             EventNumber;

  public NActionAdapter(int EventNumber, IdeEventsEngine EventsEngine) {
    this.EventsEngine = EventsEngine;
    this.EventNumber  = EventNumber;
  }

  public IdeSuperEvent PrepareEvent(int EventNumber, EventObject Event) {
    return null;
  }

  public void actionPerformed(ActionEvent e) {
    IdeSuperEvent Event;

    if(EventsEngine != null) {
      Event = PrepareEvent(EventNumber,e);
      EventsEngine.PostEvent(Event);
    }
  }
}
